/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.context.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.spring.web.context.support.PortalSessionScope;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.util.WebUtils;

public class PortalSessionScope
implements Scope {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = PortalSessionScope.class.getName() + ".DESTRUCTION_CALLBACK.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public Object resolveContextualObject(String arg0) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object sessionMutex;
        HttpSession session = this.getPortalSesion(true);
        Object object = sessionMutex = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            Object scopedObject = session.getAttribute(name);
            if (scopedObject == null) {
                scopedObject = objectFactory.getObject();
                session.setAttribute(name, scopedObject);
            }
            return scopedObject;
        }
    }

    public String getConversationId() {
        HttpSession session = this.getPortalSesion(false);
        if (session == null) {
            return null;
        }
        return session.getId();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        HttpSession session = this.getPortalSesion(true);
        DestructionCallbackBindingListener callbackListener = new DestructionCallbackBindingListener(callback);
        session.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name, (Object)callbackListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        Object sessionMutex;
        HttpSession session = this.getPortalSesion(false);
        if (session == null) {
            return null;
        }
        Object object = sessionMutex = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            Object attribute = session.getAttribute(name);
            if (attribute != null) {
                session.removeAttribute(name);
            }
            return attribute;
        }
    }

    protected HttpSession getPortalSesion(boolean create) {
        HttpServletRequest portalRequest = this.portalRequestUtils.getCurrentPortalRequest();
        return portalRequest.getSession(create);
    }
}

