/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAware;
import org.jasig.portal.tools.DbTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;

@Component(value="dbTest")
@Lazy
@DependsOn(value={"PortalDbEntityManagerFactory", "AggrEventsDbEntityManagerFactory", "RawEventsDbEntityManagerFactory", "jdbcOperations", "rawEventsJdbcOperations", "aggrEventsJdbcOperations", "hibernateConfigurationAwareInjector"})
public class DbTestImpl
implements HibernateConfigurationAware,
DbTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, DelegatingHibernateIntegrator.HibernateConfiguration> hibernateConfigurations = new ConcurrentHashMap();
    private Map<String, JdbcOperations> jdbcOperations;

    public boolean supports(String persistenceUnit) {
        return true;
    }

    public void setConfiguration(String persistenceUnit, DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration) {
        this.hibernateConfigurations.put(persistenceUnit, hibernateConfiguration);
    }

    @Autowired
    public void setJdbcOperations(Map<String, JdbcOperations> jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public void printDbInfo() {
        boolean fail = false;
        this.logger.info("JDBC DataSources");
        for (Map.Entry jdbcEntry : this.jdbcOperations.entrySet()) {
            String jdbcName = (String)jdbcEntry.getKey();
            try {
                this.logger.info("\t" + jdbcName);
                JdbcOperations jdbcOps = (JdbcOperations)jdbcEntry.getValue();
                jdbcOps.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                this.logger.error("\t" + jdbcName + ": parse info", (Throwable)e);
                fail = true;
            }
            this.logger.info("");
        }
        this.logger.info("Hibernate Dialects");
        for (Map.Entry configEntry : this.hibernateConfigurations.entrySet()) {
            String persistenceUnit = (String)configEntry.getKey();
            try {
                DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration = (DelegatingHibernateIntegrator.HibernateConfiguration)configEntry.getValue();
                SessionFactoryImplementor sessionFactory = hibernateConfiguration.getSessionFactory();
                Dialect dialect = sessionFactory.getDialect();
                this.logger.info("\t" + persistenceUnit + ": " + dialect);
            }
            catch (Exception e) {
                this.logger.error("\t" + persistenceUnit + ": Failed to resolve Dialect", (Throwable)e);
                fail = true;
            }
            this.logger.info("");
        }
        if (fail) {
            throw new RuntimeException("One or more of the portal data sources is not configured correctly or the target database is not available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void printInfo(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        String dbName = dbMetaData.getDatabaseProductName();
        String dbVersion = dbMetaData.getDatabaseProductVersion();
        String driverName = dbMetaData.getDriverName();
        String driverVersion = dbMetaData.getDriverVersion();
        int databaseMajorVersion = dbMetaData.getDatabaseMajorVersion();
        int databaseMinorVersion = dbMetaData.getDatabaseMinorVersion();
        int driverMajorVersion = dbMetaData.getDriverMajorVersion();
        int driverMinorVersion = dbMetaData.getDriverMinorVersion();
        String driverClass = RDBMServices.getJdbcDriver();
        String url = RDBMServices.getJdbcUrl();
        String user = RDBMServices.getJdbcUser();
        boolean supportsANSI92EntryLevelSQL = dbMetaData.supportsANSI92EntryLevelSQL();
        boolean supportsANSI92FullSQL = dbMetaData.supportsANSI92FullSQL();
        boolean supportsBatchUpdates = dbMetaData.supportsBatchUpdates();
        boolean supportsColumnAliasing = dbMetaData.supportsColumnAliasing();
        boolean supportsCoreSQLGrammar = dbMetaData.supportsCoreSQLGrammar();
        boolean supportsExtendedSQLGrammar = dbMetaData.supportsExtendedSQLGrammar();
        boolean supportsExpressionsInOrderBy = dbMetaData.supportsExpressionsInOrderBy();
        boolean supportsOuterJoins = dbMetaData.supportsOuterJoins();
        boolean supportsFullOuterJoins = dbMetaData.supportsFullOuterJoins();
        boolean supportsLimitedOuterJoins = dbMetaData.supportsLimitedOuterJoins();
        boolean supportsMultipleTransactions = dbMetaData.supportsMultipleTransactions();
        boolean supportsOpenCursorsAcrossCommit = dbMetaData.supportsOpenCursorsAcrossCommit();
        boolean supportsOpenCursorsAcrossRollback = dbMetaData.supportsOpenCursorsAcrossRollback();
        boolean supportsOpenStatementsAcrossCommit = dbMetaData.supportsOpenStatementsAcrossCommit();
        boolean supportsOpenStatementsAcrossRollback = dbMetaData.supportsOpenStatementsAcrossRollback();
        boolean supportsOrderByUnrelated = dbMetaData.supportsOrderByUnrelated();
        boolean supportsPositionedDelete = dbMetaData.supportsPositionedDelete();
        boolean supportsSelectForUpdate = dbMetaData.supportsSelectForUpdate();
        boolean supportsStoredProcedures = dbMetaData.supportsStoredProcedures();
        boolean supportsTransactions = dbMetaData.supportsTransactions();
        boolean supportsUnion = dbMetaData.supportsUnion();
        boolean supportsUnionAll = dbMetaData.supportsUnionAll();
        int getMaxColumnNameLength = dbMetaData.getMaxColumnNameLength();
        int getMaxColumnsInIndex = dbMetaData.getMaxColumnsInIndex();
        int getMaxColumnsInOrderBy = dbMetaData.getMaxColumnsInOrderBy();
        int getMaxColumnsInSelect = dbMetaData.getMaxColumnsInSelect();
        int getMaxColumnsInTable = dbMetaData.getMaxColumnsInTable();
        int getMaxConnections = dbMetaData.getMaxConnections();
        int getMaxCursorNameLength = dbMetaData.getMaxCursorNameLength();
        int getMaxIndexLength = dbMetaData.getMaxIndexLength();
        int getMaxRowSize = dbMetaData.getMaxRowSize();
        int getMaxStatements = dbMetaData.getMaxStatements();
        int getMaxTableNameLength = dbMetaData.getMaxTableNameLength();
        int getMaxTablesInSelect = dbMetaData.getMaxTablesInSelect();
        int getMaxUserNameLength = dbMetaData.getMaxUserNameLength();
        String getSearchStringEscape = dbMetaData.getSearchStringEscape();
        String getStringFunctions = dbMetaData.getStringFunctions();
        String getSystemFunctions = dbMetaData.getSystemFunctions();
        String getTimeDateFunctions = dbMetaData.getTimeDateFunctions();
        this.logger.info("\t\tDatabase name:    '" + dbName + "'");
        this.logger.info("\t\tDatabase version: '" + dbVersion + "' (" + databaseMajorVersion + "." + databaseMinorVersion + ")");
        this.logger.info("\t\tDriver name:      '" + driverName + "'");
        this.logger.info("\t\tDriver version:   '" + driverVersion + "' (" + driverMajorVersion + "." + driverMinorVersion + ")");
        this.logger.info("\t\tDriver class:     '" + driverClass + "'");
        this.logger.info("\t\tConnection URL:   '" + url + "'");
        this.logger.info("\t\tUser:             '" + user + "'");
        this.logger.info("");
        this.logger.info("\t\tsupportsANSI92EntryLevelSQL: " + supportsANSI92EntryLevelSQL);
        this.logger.info("\t\tsupportsANSI92FullSQL:       " + supportsANSI92FullSQL);
        this.logger.info("\t\tsupportsCoreSQLGrammar:      " + supportsCoreSQLGrammar);
        this.logger.info("\t\tsupportsExtendedSQLGrammar:  " + supportsExtendedSQLGrammar);
        this.logger.info("");
        this.logger.info("\t\tsupportsTransactions:         " + supportsTransactions);
        this.logger.info("\t\tsupportsMultipleTransactions: " + supportsMultipleTransactions);
        this.logger.info("\t\tsupportsOpenCursorsAcrossCommit:      " + supportsOpenCursorsAcrossCommit);
        this.logger.info("\t\tsupportsOpenCursorsAcrossRollback:    " + supportsOpenCursorsAcrossRollback);
        this.logger.info("\t\tsupportsOpenStatementsAcrossCommit:   " + supportsOpenStatementsAcrossCommit);
        this.logger.info("\t\tsupportsOpenStatementsAcrossRollback: " + supportsOpenStatementsAcrossRollback);
        this.logger.info("");
        this.logger.info("\t\tsupportsStoredProcedures:     " + supportsStoredProcedures);
        this.logger.info("\t\tsupportsOuterJoins:           " + supportsOuterJoins);
        this.logger.info("\t\tsupportsFullOuterJoins:       " + supportsFullOuterJoins);
        this.logger.info("\t\tsupportsLimitedOuterJoins:    " + supportsLimitedOuterJoins);
        this.logger.info("\t\tsupportsBatchUpdates:         " + supportsBatchUpdates);
        this.logger.info("\t\tsupportsColumnAliasing:       " + supportsColumnAliasing);
        this.logger.info("\t\tsupportsExpressionsInOrderBy: " + supportsExpressionsInOrderBy);
        this.logger.info("\t\tsupportsOrderByUnrelated:     " + supportsOrderByUnrelated);
        this.logger.info("\t\tsupportsPositionedDelete:     " + supportsPositionedDelete);
        this.logger.info("\t\tsupportsSelectForUpdate:      " + supportsSelectForUpdate);
        this.logger.info("\t\tsupportsUnion:                " + supportsUnion);
        this.logger.info("\t\tsupportsUnionAll:             " + supportsUnionAll);
        this.logger.info("");
        this.logger.info("\t\tmaxColumnNameLength: " + getMaxColumnNameLength);
        this.logger.info("\t\tmaxColumnsInIndex:   " + getMaxColumnsInIndex);
        this.logger.info("\t\tmaxColumnsInOrderBy: " + getMaxColumnsInOrderBy);
        this.logger.info("\t\tmaxColumnsInSelect:  " + getMaxColumnsInSelect);
        this.logger.info("\t\tmaxColumnsInTable:   " + getMaxColumnsInTable);
        this.logger.info("\t\tmaxConnections:      " + getMaxConnections);
        this.logger.info("\t\tmaxCursorNameLength: " + getMaxCursorNameLength);
        this.logger.info("\t\tmaxIndexLength:      " + getMaxIndexLength);
        this.logger.info("\t\tmaxRowSize:          " + getMaxRowSize);
        this.logger.info("\t\tmaxStatements:       " + getMaxStatements);
        this.logger.info("\t\tmaxTableNameLength:  " + getMaxTableNameLength);
        this.logger.info("\t\tmaxTablesInSelect:   " + getMaxTablesInSelect);
        this.logger.info("\t\tmaxUserNameLength:   " + getMaxUserNameLength);
        this.logger.info("\t\tsearchStringEscape:  " + getSearchStringEscape);
        this.logger.info("\t\tstringFunctions:     " + getStringFunctions);
        this.logger.info("\t\tsystemFunctions:     " + getSystemFunctions);
        this.logger.info("\t\ttimeDateFunctions:   " + getTimeDateFunctions);
        this.logger.info("");
        ResultSet getTableTypes = null;
        ResultSet getTypeInfo = null;
        try {
            getTableTypes = dbMetaData.getTableTypes();
            StringBuilder tabletypes = new StringBuilder();
            while (getTableTypes.next()) {
                tabletypes.append(getTableTypes.getString(1)).append(",");
            }
            tabletypes = tabletypes.deleteCharAt(tabletypes.length() - 1);
            this.logger.info("\t\tTable Types: " + tabletypes);
            getTypeInfo = dbMetaData.getTypeInfo();
            StringBuilder typeinfo = new StringBuilder();
            while (getTypeInfo.next()) {
                typeinfo.append(getTypeInfo.getString(1)).append(",");
            }
            typeinfo = typeinfo.deleteCharAt(typeinfo.length() - 1);
            this.logger.info("\t\tSQL Types:   " + typeinfo);
        }
        catch (SQLException ex) {
            JdbcUtils.closeResultSet((ResultSet)getTableTypes);
            JdbcUtils.closeResultSet(getTypeInfo);
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet((ResultSet)getTableTypes);
                JdbcUtils.closeResultSet(getTypeInfo);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)getTableTypes);
        JdbcUtils.closeResultSet((ResultSet)getTypeInfo);
    }

    static /* synthetic */ void access$000(DbTestImpl x0, Connection x1) throws SQLException {
        x0.printInfo(x1);
    }
}

