/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class GuestSessionExpirationInterceptor
extends HandlerInterceptorAdapter {
    private IPersonManager personManager;
    private int unauthenticatedUserSessionTimeout = 0;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public void setUnauthenticatedUserSessionTimeout(int unauthenticatedUserSessionTimeout) {
        this.unauthenticatedUserSessionTimeout = unauthenticatedUserSessionTimeout;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.unauthenticatedUserSessionTimeout <= 0) {
            return true;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        IPerson person = this.personManager.getPerson(request);
        if (person != null && !person.getSecurityContext().isAuthenticated()) {
            session.setMaxInactiveInterval(this.unauthenticatedUserSessionTimeout);
        }
        return true;
    }
}

