/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IUrlNodeSyntaxHelper;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileUrlNodeSyntaxHelper
implements IUrlNodeSyntaxHelper {
    public static final char PORTLET_PATH_ELEMENT_SEPERATOR = '.';
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUserInstanceManager userInstanceManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDefaultLayoutNodeId(HttpServletRequest httpServletRequest) {
        return null;
    }

    @RequestCache(keyMask={false, true})
    public List<String> getFolderNamesForLayoutNode(HttpServletRequest request, String layoutNodeId) {
        return Collections.emptyList();
    }

    public String getLayoutNodeForFolderNames(HttpServletRequest request, List<String> folderNames) {
        return null;
    }

    @RequestCache(keyMask={false, true})
    public String getFolderNameForPortlet(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        String fname = portletDefinition.getFName();
        String channelSubscribeId = portletEntity.getLayoutNodeId();
        return fname + '.' + channelSubscribeId;
    }

    public IPortletWindowId getPortletForFolderName(HttpServletRequest request, String targetedLayoutNodeId, String folderName) {
        IPortletEntity portletEntity;
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        int seperatorIndex = folderName.indexOf(46);
        if (seperatorIndex <= 0 || seperatorIndex + 1 == folderName.length()) {
            String fname = folderName;
            portletEntity = this.portletEntityRegistry.getOrCreatePortletEntityByFname(request, userInstance, fname);
        } else {
            String fname = folderName.substring(0, seperatorIndex);
            String subscribeId = folderName.substring(seperatorIndex + 1);
            portletEntity = this.portletEntityRegistry.getOrCreatePortletEntityByFname(request, userInstance, fname, subscribeId);
        }
        if (portletEntity != null) {
            IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
            IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindow(request, portletEntityId);
            return portletWindow.getPortletWindowId();
        }
        this.logger.warn(targetedLayoutNodeId + " node for portlet of folder " + folderName + " can't be targeted by the request.");
        return null;
    }
}

