/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.AbstractUrlBuilder;
import org.jasig.portal.url.IPortalActionUrlBuilder;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.PortletUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.utils.ConcurrentMapUtils;

class PortalUrlBuilder
extends AbstractUrlBuilder
implements IPortalActionUrlBuilder {
    final IUrlSyntaxProvider urlGenerator;
    final HttpServletRequest httpServletRequest;
    private final String targetFolderId;
    private final IPortletWindowId targetPortletWindowId;
    private final UrlType urlType;
    private final ConcurrentMap<IPortletWindowId, IPortletUrlBuilder> portletUrlBuilders = new ConcurrentHashMap();
    private String location;
    private String renderUrlParamName;

    public PortalUrlBuilder(IUrlSyntaxProvider urlSyntaxProvider, HttpServletRequest httpServletRequest, String targetFolderId, IPortletWindowId targetPortletWindowId, UrlType urlType) {
        Preconditions.checkNotNull((Object)urlSyntaxProvider, (Object)"IUrlSyntaxProvider can not be null");
        Preconditions.checkNotNull((Object)httpServletRequest, (Object)"HttpServletRequest can not be null");
        Preconditions.checkNotNull((Object)urlType, (Object)"UrlType can not be null");
        this.urlGenerator = urlSyntaxProvider;
        this.httpServletRequest = httpServletRequest;
        this.targetFolderId = targetFolderId;
        this.targetPortletWindowId = targetPortletWindowId;
        this.urlType = urlType;
    }

    public String getTargetFolderId() {
        return this.targetFolderId;
    }

    public IPortletWindowId getTargetPortletWindowId() {
        return this.targetPortletWindowId;
    }

    public UrlType getUrlType() {
        return this.urlType;
    }

    public void setRedirectLocation(String location) {
        this.setRedirectLocation(location, null);
    }

    public void setRedirectLocation(String location, String renderUrlParamName) {
        this.location = location;
        this.renderUrlParamName = renderUrlParamName;
    }

    public String getRedirectLocation() {
        return this.location;
    }

    public String getRenderUrlParamName() {
        return this.renderUrlParamName;
    }

    public IPortletUrlBuilder getPortletUrlBuilder(IPortletWindowId portletWindowId) {
        IPortletUrlBuilder portletUrlBuilder = (IPortletUrlBuilder)this.portletUrlBuilders.get(portletWindowId);
        if (portletUrlBuilder == null) {
            portletUrlBuilder = (IPortletUrlBuilder)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.portletUrlBuilders, (Object)portletWindowId, (Object)new PortletUrlBuilder(portletWindowId, (IPortalUrlBuilder)this));
        }
        return portletUrlBuilder;
    }

    public IPortletUrlBuilder getTargetedPortletUrlBuilder() {
        if (this.targetPortletWindowId == null) {
            throw new IllegalStateException("This url must target a portlet for this call to be valid");
        }
        return this.getPortletUrlBuilder(this.targetPortletWindowId);
    }

    public Map<IPortletWindowId, IPortletUrlBuilder> getPortletUrlBuilders() {
        return Collections.unmodifiableMap(this.portletUrlBuilders);
    }

    public String getUrlString() {
        return this.urlGenerator.generateUrl(this.httpServletRequest, (IPortalActionUrlBuilder)this);
    }

    public String toString() {
        return "PortalUrlBuilder [targetFolderId=" + this.targetFolderId + ", targetPortletWindowId=" + this.targetPortletWindowId + ", urlType=" + this.urlType + ", parameters=" + this.getParameters() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targetFolderId == null ? 0 : this.targetFolderId.hashCode());
        result = 31 * result + (this.targetPortletWindowId == null ? 0 : this.targetPortletWindowId.hashCode());
        result = 31 * result + (this.urlType == null ? 0 : this.urlType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortalUrlBuilder other = (PortalUrlBuilder)obj;
        if (this.targetFolderId == null ? other.targetFolderId != null : !this.targetFolderId.equals(other.targetFolderId)) {
            return false;
        }
        if (this.targetPortletWindowId == null ? other.targetPortletWindowId != null : !this.targetPortletWindowId.equals(other.targetPortletWindowId)) {
            return false;
        }
        return this.urlType == other.urlType;
    }
}

