/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequireValidSessionFilter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        HttpSession session = request.getSession(false);
        return session != null && !session.isNew();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        StringBuilder loginRedirect = new StringBuilder();
        loginRedirect.append(request.getContextPath());
        loginRedirect.append("/Login?refUrl=");
        String requestEncoding = request.getCharacterEncoding();
        loginRedirect.append(URLEncoder.encode(request.getRequestURI(), requestEncoding));
        String queryString = request.getQueryString();
        if (queryString != null) {
            loginRedirect.append(URLEncoder.encode("?", requestEncoding));
            loginRedirect.append(URLEncoder.encode(queryString, requestEncoding));
        }
        String encodedRedirectURL = response.encodeRedirectURL(loginRedirect.toString());
        response.sendRedirect(encodedRedirectURL);
    }
}

