/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.url.IPortalActionUrlBuilder;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.IUrlNodeSyntaxHelper;
import org.jasig.portal.url.IUrlNodeSyntaxHelperRegistry;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.PortalRequestInfoImpl;
import org.jasig.portal.url.PortletRequestInfoImpl;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.UrlStringBuilder;
import org.jasig.portal.url.UrlSyntaxProviderImpl;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UrlPathHelper;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="portalUrlProvider")
public class UrlSyntaxProviderImpl
implements IUrlSyntaxProvider {
    static final String SEPARATOR = "_";
    static final String PORTAL_PARAM_PREFIX = "u_";
    static final String PORTLET_CONTROL_PREFIX = "pC";
    static final String PORTLET_PARAM_PREFIX = "pP_";
    static final String PORTLET_PUBLIC_RENDER_PARAM_PREFIX = "pG_";
    static final String PARAM_TARGET_PORTLET = "pCt";
    static final String PARAM_ADDITIONAL_PORTLET = "pCa";
    static final String PARAM_DELEGATE_PARENT = "pCd";
    static final String PARAM_RESOURCE_ID = "pCr";
    static final String PARAM_CACHEABILITY = "pCc";
    static final String PARAM_WINDOW_STATE = "pCs";
    static final String PARAM_PORTLET_MODE = "pCm";
    static final String PARAM_COPY_PARAMETERS = "pCp";
    static final Set<String> LEGACY_URL_PATHS = ImmutableSet.of((Object)"/render.userLayoutRootNode.uP", (Object)"/tag.idempotent.render.userLayoutRootNode.uP");
    static final String LEGACY_PARAM_PORTLET_FNAME = "uP_fname";
    static final String LEGACY_PARAM_PORTLET_REQUEST_TYPE = "pltc_type";
    static final String LEGACY_PARAM_PORTLET_STATE = "pltc_state";
    static final String LEGACY_PARAM_PORTLET_MODE = "pltc_mode";
    static final String LEGACY_PARAM_PORTLET_PARAM_PREFX = "pltp_";
    static final String LEGACY_PARAM_LAYOUT_ROOT = "root";
    static final String LEGACY_PARAM_LAYOUT_ROOT_VALUE = "uP_root";
    static final String LEGACY_PARAM_LAYOUT_STRUCT_PARAM = "uP_sparam";
    static final String LEGACY_PARAM_LAYOUT_TAB_ID = "activeTab";
    static final String SLASH = "/";
    static final String PORTLET_PATH_PREFIX = "p";
    static final String FOLDER_PATH_PREFIX = "f";
    static final String REQUEST_TYPE_SUFFIX = ".uP";
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private static final String PORTAL_CANONICAL_URL = UrlSyntaxProviderImpl.class.getName() + ".PORTAL_CANONICAL_URL";
    private static final String PORTAL_REQUEST_INFO_ATTR = UrlSyntaxProviderImpl.class.getName() + ".PORTAL_REQUEST_INFO";
    private static final String PORTAL_REQUEST_PARSING_IN_PROGRESS_ATTR = UrlSyntaxProviderImpl.class.getName() + ".PORTAL_REQUEST_PARSING_IN_PROGRESS";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<WindowState> PATH_WINDOW_STATES = new LinkedHashSet<WindowState>(Arrays.asList(WindowState.MAXIMIZED, IPortletRenderer.DETACHED, IPortletRenderer.EXCLUSIVE));
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Set<UrlState> statelessUrlStates = EnumSet.of(UrlState.DETACHED, UrlState.EXCLUSIVE);
    private String defaultEncoding = "UTF-8";
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private IUrlNodeSyntaxHelperRegistry urlNodeSyntaxHelperRegistry;
    private IPortalUrlProvider portalUrlProvider;
    private IUserInstanceManager userInstanceManager;
    private XPathOperations xpathOperations;

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setXpathOperations(XPathOperations xpathOperations) {
        this.xpathOperations = xpathOperations;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider portalUrlProvider) {
        this.portalUrlProvider = portalUrlProvider;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setUrlNodeSyntaxHelperRegistry(IUrlNodeSyntaxHelperRegistry urlNodeSyntaxHelperRegistry) {
        this.urlNodeSyntaxHelperRegistry = urlNodeSyntaxHelperRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPortalRequestInfo getPortalRequestInfo(HttpServletRequest request) {
        IPortalRequestInfo cachedPortalRequestInfo = (IPortalRequestInfo)(request = this.portalRequestUtils.getOriginalPortalRequest(request)).getAttribute(PORTAL_REQUEST_INFO_ATTR);
        if (cachedPortalRequestInfo != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("short-circuit: found portalRequestInfo within request attributes");
            }
            return cachedPortalRequestInfo;
        }
        Object object = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            Boolean inProgressAttr = (Boolean)request.getAttribute(PORTAL_REQUEST_PARSING_IN_PROGRESS_ATTR);
            if (inProgressAttr != null && inProgressAttr.booleanValue()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Portal request info parsing already in progress, returning null");
                }
                return null;
            }
            request.setAttribute(PORTAL_REQUEST_PARSING_IN_PROGRESS_ATTR, (Object)Boolean.TRUE);
        }
        try {
            Object[] additionalPortletIdArray;
            ParameterMap parameterMap = new ParameterMap(request.getParameterMap());
            String requestPath = this.urlPathHelper.getPathWithinApplication(request);
            if (LEGACY_URL_PATHS.contains(requestPath)) {
                IPortalRequestInfo iPortalRequestInfo = this.parseLegacyPortalUrl(request, (Map)parameterMap);
                return iPortalRequestInfo;
            }
            IUrlNodeSyntaxHelper urlNodeSyntaxHelper = this.urlNodeSyntaxHelperRegistry.getCurrentUrlNodeSyntaxHelper(request);
            PortalRequestInfoImpl portalRequestInfo = new PortalRequestInfoImpl();
            IPortletWindowId targetedPortletWindowId = null;
            PortletRequestInfoImpl targetedPortletRequestInfo = null;
            String[] requestPathParts = SLASH_PATTERN.split(requestPath);
            UrlState requestedUrlState = null;
            ParseStep parseStep = ParseStep.FOLDER;
            block18: for (int pathPartIndex = 0; pathPartIndex < requestPathParts.length; ++pathPartIndex) {
                String pathPart = requestPathParts[pathPartIndex];
                if (StringUtils.isEmpty((String)pathPart)) continue;
                switch (2.$SwitchMap$org$jasig$portal$url$UrlSyntaxProviderImpl$ParseStep[parseStep.ordinal()]) {
                    case 1: {
                        parseStep = ParseStep.PORTLET;
                        if ("f".equals(pathPart)) {
                            ++pathPartIndex;
                            LinkedList<String> folders = new LinkedList<String>();
                            while (pathPartIndex < requestPathParts.length) {
                                pathPart = requestPathParts[pathPartIndex];
                                if ("p".equals(pathPart)) {
                                    --pathPartIndex;
                                    break;
                                }
                                if (pathPart.endsWith(".uP")) {
                                    if (UrlState.valueOfIngoreCase((String)(pathPart = requestPathParts[--pathPartIndex]), null) == null) break;
                                    folders.removeLast();
                                    --pathPartIndex;
                                    break;
                                }
                                folders.add(pathPart);
                                ++pathPartIndex;
                            }
                            if (folders.size() <= 0) continue block18;
                            String targetedLayoutNodeId = urlNodeSyntaxHelper.getLayoutNodeForFolderNames(request, folders);
                            portalRequestInfo.setTargetedLayoutNodeId(targetedLayoutNodeId);
                            continue block18;
                        }
                    }
                    case 2: {
                        parseStep = ParseStep.STATE;
                        String targetedLayoutNodeId = portalRequestInfo.getTargetedLayoutNodeId();
                        if ("p".equals(pathPart)) {
                            if (++pathPartIndex >= requestPathParts.length) continue block18;
                            pathPart = requestPathParts[pathPartIndex];
                            targetedPortletWindowId = urlNodeSyntaxHelper.getPortletForFolderName(request, targetedLayoutNodeId, pathPart);
                            continue block18;
                        }
                        String[] targetedPortletIds = (String[])parameterMap.remove("pCt");
                        if (targetedPortletIds != null && targetedPortletIds.length > 0) {
                            String targetedPortletString = targetedPortletIds[0];
                            targetedPortletWindowId = urlNodeSyntaxHelper.getPortletForFolderName(request, targetedLayoutNodeId, targetedPortletString);
                        }
                    }
                    case 3: {
                        parseStep = ParseStep.TYPE;
                        if (targetedPortletWindowId == null) continue block18;
                        requestedUrlState = UrlState.valueOfIngoreCase((String)pathPart, null);
                        if (requestedUrlState != null) {
                            portalRequestInfo.setUrlState(requestedUrlState);
                            if (this.statelessUrlStates.contains(requestedUrlState)) {
                                IPortletWindow statelessPortletWindow = this.portletWindowRegistry.getOrCreateStatelessPortletWindow(request, targetedPortletWindowId);
                                targetedPortletWindowId = statelessPortletWindow.getPortletWindowId();
                            }
                            targetedPortletRequestInfo = portalRequestInfo.getPortletRequestInfo(targetedPortletWindowId);
                            portalRequestInfo.setTargetedPortletWindowId(targetedPortletWindowId);
                            switch (2.$SwitchMap$org$jasig$portal$url$UrlState[requestedUrlState.ordinal()]) {
                                case 1: {
                                    targetedPortletRequestInfo.setWindowState(WindowState.MAXIMIZED);
                                    break;
                                }
                                case 2: {
                                    targetedPortletRequestInfo.setWindowState(IPortletRenderer.DETACHED);
                                    break;
                                }
                                case 3: {
                                    targetedPortletRequestInfo.setWindowState(IPortletRenderer.EXCLUSIVE);
                                }
                            }
                            continue block18;
                        }
                    }
                    case 4: {
                        UrlType urlType;
                        parseStep = ParseStep.COMPLETE;
                        if (pathPartIndex != requestPathParts.length - 1 || !pathPart.endsWith(".uP") || pathPart.length() <= ".uP".length()) continue block18;
                        String urlTypePart = pathPart.substring(0, pathPart.length() - ".uP".length());
                        int lastPeriod = urlTypePart.lastIndexOf(46);
                        if (lastPeriod >= 0 && lastPeriod < urlTypePart.length()) {
                            String urlTypePartSuffix = urlTypePart.substring(lastPeriod + 1);
                            urlType = UrlType.valueOfIngoreCase((String)urlTypePartSuffix, null);
                            if (urlType == UrlType.RESOURCE && targetedPortletRequestInfo != null) {
                                String resourceId = urlTypePart.substring(0, lastPeriod);
                                targetedPortletRequestInfo.setResourceId(resourceId);
                            }
                        } else {
                            urlType = UrlType.valueOfIngoreCase((String)urlTypePart, null);
                        }
                        if (urlType == null) continue block18;
                        portalRequestInfo.setUrlType(urlType);
                        continue block18;
                    }
                }
            }
            if (targetedPortletWindowId != null && targetedPortletRequestInfo == null) {
                targetedPortletRequestInfo = portalRequestInfo.getPortletRequestInfo(targetedPortletWindowId);
                portalRequestInfo.setTargetedPortletWindowId(targetedPortletWindowId);
            }
            HashSet additionalPortletIds = Sets.newHashSet((Object[])((additionalPortletIdArray = (String[])parameterMap.remove("pCa")) != null ? additionalPortletIdArray : new String[]{}));
            LinkedHashMap delegateIdMappings = new LinkedHashMap(0);
            Set parameterEntrySet = parameterMap.entrySet();
            Iterator parameterEntryItr = parameterEntrySet.iterator();
            block20: while (parameterEntryItr.hasNext()) {
                Map.Entry parameterEntry = parameterEntryItr.next();
                String name = (String)parameterEntry.getKey();
                List<Object> values = Arrays.asList((Object[])parameterEntry.getValue());
                if (name.startsWith("u_")) {
                    Map portalParameters = portalRequestInfo.getPortalParameters();
                    portalParameters.put(this.safeSubstringAfter("u_", name), values);
                    parameterEntryItr.remove();
                    continue;
                }
                if (name.startsWith("pP_")) {
                    Map portletParameters;
                    Tuple portletParameterParts = this.parsePortletParameterName(request, name, (Set)additionalPortletIds);
                    IPortletWindowId portletWindowId = (IPortletWindowId)portletParameterParts.second;
                    String paramName = (String)portletParameterParts.first;
                    if (portletWindowId == null) {
                        if (targetedPortletRequestInfo == null) {
                            this.logger.warn("Parameter " + name + " is for the targeted portlet but no portlet is targeted by the request. The parameter will be ignored. Value: " + values);
                            parameterEntryItr.remove();
                            break;
                        }
                        portletParameters = targetedPortletRequestInfo.getPortletParameters();
                    } else {
                        PortletRequestInfoImpl portletRequestInfoImpl = portalRequestInfo.getPortletRequestInfo(portletWindowId);
                        portletParameters = portletRequestInfoImpl.getPortletParameters();
                    }
                    portletParameters.put(paramName, values);
                    parameterEntryItr.remove();
                    continue;
                }
                for (SuffixedPortletParameter suffixedPortletParameter : SuffixedPortletParameter.values()) {
                    String parameterPrefix = suffixedPortletParameter.getParameterPrefix();
                    if (!name.startsWith(parameterPrefix)) continue;
                    if (values.isEmpty()) {
                        this.logger.warn("Ignoring parameter " + name + " as it must have a value. Value: " + values);
                        continue block20;
                    }
                    Set validUrlTypes = suffixedPortletParameter.getValidUrlTypes();
                    if (!validUrlTypes.contains(portalRequestInfo.getUrlType())) {
                        this.logger.warn("Ignoring parameter " + name + " as it is only valid for " + validUrlTypes + " requests and this is a " + portalRequestInfo.getUrlType() + " request. Value: " + values);
                        continue block20;
                    }
                    IPortletWindowId portletWindowId = this.parsePortletWindowIdSuffix(request, parameterPrefix, (Set)additionalPortletIds, name);
                    PortletRequestInfoImpl portletRequestInfo = this.getTargetedPortletRequestInfo(portalRequestInfo, targetedPortletRequestInfo, portletWindowId);
                    if (portletRequestInfo == null) {
                        this.logger.warn("Parameter " + name + " is for the targeted portlet but no portlet is targeted by the request. The parameter will be ignored. Value: " + values);
                        continue block20;
                    }
                    parameterEntryItr.remove();
                    suffixedPortletParameter.updateRequestInfo(request, this.portletWindowRegistry, portletRequestInfo, values, delegateIdMappings);
                    continue block20;
                }
            }
            if (!parameterMap.isEmpty()) {
                Map parameters;
                if (!delegateIdMappings.isEmpty()) {
                    PortletRequestInfoImpl delegatePortletRequestInfo = null;
                    for (IPortletWindowId delegatePortletWindowId : delegateIdMappings.values()) {
                        if (delegateIdMappings.containsKey(delegatePortletWindowId)) continue;
                        delegatePortletRequestInfo = portalRequestInfo.getPortletRequestInfo(delegatePortletWindowId);
                        break;
                    }
                    if (delegatePortletRequestInfo != null) {
                        parameters = delegatePortletRequestInfo.getPortletParameters();
                    } else {
                        this.logger.warn("No root delegate portlet could be resolved, non-namespaced parameters will be sent to the targeted portlet. THIS SHOULD NEVER HAPPEN. Delegate parent/child mapping: " + delegateIdMappings);
                        parameters = targetedPortletRequestInfo != null ? targetedPortletRequestInfo.getPortletParameters() : portalRequestInfo.getPortalParameters();
                    }
                } else {
                    parameters = targetedPortletRequestInfo != null ? targetedPortletRequestInfo.getPortletParameters() : portalRequestInfo.getPortalParameters();
                }
                ParameterMap.putAllList((Map)parameters, (Map)parameterMap);
            }
            if (targetedPortletRequestInfo != null && portalRequestInfo.getTargetedLayoutNodeId() == null && (requestedUrlState == null || requestedUrlState == UrlState.NORMAL)) {
                portalRequestInfo.setUrlState(UrlState.MAX);
                targetedPortletRequestInfo.setWindowState(WindowState.MAXIMIZED);
            }
            portalRequestInfo.makeReadOnly();
            request.setAttribute(PORTAL_REQUEST_INFO_ATTR, (Object)portalRequestInfo);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("finished building requestInfo: " + portalRequestInfo);
            }
            PortalRequestInfoImpl portalRequestInfoImpl = portalRequestInfo;
            return portalRequestInfoImpl;
        }
        finally {
            request.removeAttribute(PORTAL_REQUEST_PARSING_IN_PROGRESS_ATTR);
        }
    }

    protected IPortalRequestInfo parseLegacyPortalUrl(HttpServletRequest request, Map<String, String[]> parameterMap) {
        String[] activeTabId;
        String[] structParam;
        String[] root;
        PortalRequestInfoImpl portalRequestInfo = new PortalRequestInfoImpl();
        String[] fname = parameterMap.remove("uP_fname");
        if (fname != null && fname.length > 0) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(request, fname[0]);
            if (portletWindow != null) {
                String[] mode;
                String[] state;
                this.logger.debug("Legacy fname parameter {} resolved to {}", (Object)fname[0], (Object)portletWindow);
                IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
                portalRequestInfo.setTargetedPortletWindowId(portletWindowId);
                PortletRequestInfoImpl portletRequestInfo = portalRequestInfo.getPortletRequestInfo(portletWindowId);
                String[] type = parameterMap.remove("pltc_type");
                if (type != null && type.length > 0 && "ACTION".equals(type[0])) {
                    portalRequestInfo.setUrlType(UrlType.ACTION);
                }
                if ((state = parameterMap.remove("pltc_state")) != null && state.length > 0) {
                    WindowState windowState = PortletUtils.getWindowState((String)state[0]);
                    if (portalRequestInfo.getUrlType() == UrlType.ACTION || PATH_WINDOW_STATES.contains(windowState)) {
                        portletRequestInfo.setWindowState(windowState);
                    }
                }
                if (portletRequestInfo.getWindowState() == null) {
                    portletRequestInfo.setWindowState(WindowState.MAXIMIZED);
                }
                if ((mode = parameterMap.remove("pltc_mode")) != null && mode.length > 0) {
                    PortletMode portletMode = PortletUtils.getPortletMode((String)mode[0]);
                    portletRequestInfo.setPortletMode(portletMode);
                }
                Map portletParameters = portletRequestInfo.getPortletParameters();
                for (Map.Entry<String, String[]> parameterEntry : parameterMap.entrySet()) {
                    String prefixedName = parameterEntry.getKey();
                    if (!prefixedName.startsWith("pltp_")) continue;
                    String name = prefixedName.substring("pltp_".length());
                    portletParameters.put(name, Arrays.asList((Object[])parameterEntry.getValue()));
                }
                UrlState urlState = this.determineUrlState(portletWindow, portletRequestInfo.getWindowState());
                portalRequestInfo.setUrlState(urlState);
            } else {
                this.logger.debug("Could not find portlet for legacy fname fname parameter {}", (Object)fname[0]);
            }
        }
        if ((root = parameterMap.remove("root")) != null && root.length > 0 && "uP_root".equals(root[0]) && (structParam = parameterMap.remove("uP_sparam")) != null && structParam.length > 0 && "activeTab".equals(structParam[0]) && (activeTabId = parameterMap.remove("activeTab")) != null && activeTabId.length > 0) {
            IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
            IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
            IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
            IUserLayout userLayout = userLayoutManager.getUserLayout();
            String nodeId = (String)this.xpathOperations.doWithExpression("/layout/folder/folder[@type='regular' and @hidden='false'][position() = $activeTabId]/@ID", Collections.singletonMap("activeTabId", activeTabId[0]), (Function)new /* Unavailable Anonymous Inner Class!! */);
            if (nodeId != null) {
                this.logger.debug("Found layout node {} for legacy activeTabId parameter {}", (Object)nodeId, (Object)activeTabId[0]);
                portalRequestInfo.setTargetedLayoutNodeId(nodeId);
            } else {
                this.logger.debug("No layoout node found for legacy activeTabId parameter {}", (Object)activeTabId[0]);
            }
        }
        return portalRequestInfo;
    }

    protected PortletRequestInfoImpl getTargetedPortletRequestInfo(PortalRequestInfoImpl portalRequestInfo, PortletRequestInfoImpl targetedPortletRequestInfo, IPortletWindowId targetedPortletWindowId) {
        if (targetedPortletWindowId == null) {
            return targetedPortletRequestInfo;
        }
        return portalRequestInfo.getPortletRequestInfo(targetedPortletWindowId);
    }

    protected Tuple<String, IPortletWindowId> parsePortletParameterName(HttpServletRequest request, String name, Set<String> additionalPortletIds) {
        for (String additionalPortletId : additionalPortletIds) {
            int windowIdIdx = name.indexOf(additionalPortletId);
            if (windowIdIdx == -1) continue;
            String paramName = name.substring("pP_".length() + additionalPortletId.length() + "_".length());
            IPortletWindowId portletWindowId = this.portletWindowRegistry.getPortletWindowId(request, additionalPortletId);
            return new Tuple((Object)paramName, (Object)portletWindowId);
        }
        String paramName = this.safeSubstringAfter("pP_", name);
        return new Tuple((Object)paramName, null);
    }

    protected IPortletWindowId parsePortletWindowIdSuffix(HttpServletRequest request, String prefix, Set<String> additionalPortletIds, String name) {
        int windowIdStartIdx = name.indexOf("_", prefix.length());
        if (windowIdStartIdx < prefix.length() + "_".length() - 1) {
            return null;
        }
        String portletWindowIdStr = name.substring(windowIdStartIdx + "_".length());
        if (additionalPortletIds.contains(portletWindowIdStr)) {
            try {
                return this.portletWindowRegistry.getPortletWindowId(request, portletWindowIdStr);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Failed to parse portlet window id: " + portletWindowIdStr + " null will be returned", (Throwable)e);
            }
        }
        return null;
    }

    protected String safeSubstringAfter(String prefix, String fullName) {
        if (prefix.length() >= fullName.length()) {
            return "";
        }
        return fullName.substring(prefix.length());
    }

    public String getCanonicalUrl(HttpServletRequest request) {
        String cachedCanonicalUrl = (String)(request = this.portalRequestUtils.getOriginalPortalRequest(request)).getAttribute(PORTAL_CANONICAL_URL);
        if (cachedCanonicalUrl != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("short-circuit: found canonicalUrl within request attributes");
            }
            return cachedCanonicalUrl;
        }
        IPortalRequestInfo portalRequestInfo = this.getPortalRequestInfo(request);
        UrlType urlType = portalRequestInfo.getUrlType();
        IPortletWindowId targetedPortletWindowId = portalRequestInfo.getTargetedPortletWindowId();
        String targetedLayoutNodeId = portalRequestInfo.getTargetedLayoutNodeId();
        IPortalUrlBuilder portalUrlBuilder = targetedPortletWindowId != null ? this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(request, targetedPortletWindowId, urlType) : (targetedLayoutNodeId != null ? this.portalUrlProvider.getPortalUrlBuilderByLayoutNode(request, targetedLayoutNodeId, urlType) : this.portalUrlProvider.getDefaultUrl(request));
        Map portalParameters = portalRequestInfo.getPortalParameters();
        portalUrlBuilder.setParameters(portalParameters);
        for (IPortletRequestInfo portletRequestInfo : portalRequestInfo.getPortletRequestInfoMap().values()) {
            IPortletWindowId portletWindowId = portletRequestInfo.getPortletWindowId();
            IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(portletWindowId);
            Map portletParameters = portletRequestInfo.getPortletParameters();
            portletUrlBuilder.setParameters(portletParameters);
            switch (2.$SwitchMap$org$jasig$portal$url$UrlType[urlType.ordinal()]) {
                case 1: {
                    portletUrlBuilder.setCacheability(portletRequestInfo.getCacheability());
                    portletUrlBuilder.setResourceId(portletRequestInfo.getResourceId());
                }
                case 2: 
                case 3: {
                    portletUrlBuilder.setWindowState(portletRequestInfo.getWindowState());
                    portletUrlBuilder.setPortletMode(portletRequestInfo.getPortletMode());
                }
            }
        }
        return portalUrlBuilder.getUrlString();
    }

    public String generateUrl(HttpServletRequest request, IPortalActionUrlBuilder portalActionUrlBuilder) {
        String encodedPortalRenderUrl;
        String encodedRenderUrlParamName;
        String redirectLocation = portalActionUrlBuilder.getRedirectLocation();
        if (redirectLocation == null) {
            return this.generateUrl(request, (IPortalUrlBuilder)portalActionUrlBuilder);
        }
        String renderUrlParamName = portalActionUrlBuilder.getRenderUrlParamName();
        if (renderUrlParamName == null) {
            return redirectLocation;
        }
        StringBuilder redirectLocationBuilder = new StringBuilder(redirectLocation);
        int queryParamStartIndex = redirectLocationBuilder.indexOf("?");
        if (queryParamStartIndex > -1) {
            redirectLocationBuilder.append('&');
        } else {
            redirectLocationBuilder.append('?');
        }
        String portalRenderUrl = this.generateUrl(request, (IPortalUrlBuilder)portalActionUrlBuilder);
        String encoding = this.getEncoding(request);
        try {
            encodedRenderUrlParamName = URLEncoder.encode(renderUrlParamName, encoding);
            encodedPortalRenderUrl = URLEncoder.encode(portalRenderUrl, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding '" + encoding + "' is not supported.", e);
        }
        return redirectLocationBuilder.append(encodedRenderUrlParamName).append("=").append(encodedPortalRenderUrl).toString();
    }

    public String generateUrl(HttpServletRequest request, IPortalUrlBuilder portalUrlBuilder) {
        UrlState urlState;
        String resourceId;
        Validate.notNull((Object)request, (String)"HttpServletRequest was null");
        Validate.notNull((Object)portalUrlBuilder, (String)"IPortalPortletUrl was null");
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        IUrlNodeSyntaxHelper urlNodeSyntaxHelper = this.urlNodeSyntaxHelperRegistry.getCurrentUrlNodeSyntaxHelper(request);
        String encoding = this.getEncoding(request);
        String contextPath = this.getCleanedContextPath(request);
        UrlStringBuilder url = new UrlStringBuilder(encoding, contextPath.length() > 0 ? contextPath : null);
        Map portletUrlBuilders = portalUrlBuilder.getPortletUrlBuilders();
        IPortletWindowId targetedPortletWindowId = portalUrlBuilder.getTargetPortletWindowId();
        UrlType urlType = portalUrlBuilder.getUrlType();
        if (targetedPortletWindowId != null) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, targetedPortletWindowId);
            IPortletEntity portletEntity = portletWindow.getPortletEntity();
            String channelSubscribeId = portletEntity.getLayoutNodeId();
            List folderNames = urlNodeSyntaxHelper.getFolderNamesForLayoutNode(request, channelSubscribeId);
            if (!folderNames.isEmpty()) {
                url.addPath("f");
                for (String folderName : folderNames) {
                    url.addPath(folderName);
                }
            }
            IPortletUrlBuilder targetedPortletUrlBuilder = (IPortletUrlBuilder)portletUrlBuilders.get(targetedPortletWindowId);
            resourceId = urlType == UrlType.RESOURCE && targetedPortletUrlBuilder != null ? targetedPortletUrlBuilder.getResourceId() : null;
            urlState = this.determineUrlState(portletWindow, targetedPortletUrlBuilder);
            String targetedPortletString = urlNodeSyntaxHelper.getFolderNameForPortlet(request, targetedPortletWindowId);
            if (urlType == UrlType.RENDER && urlState != UrlState.NORMAL || urlType == UrlType.ACTION || urlType == UrlType.RESOURCE) {
                url.addPath("p");
                url.addPath(targetedPortletString);
            } else {
                url.addParameter("pCt", new String[]{targetedPortletString});
            }
        } else {
            String targetFolderId = portalUrlBuilder.getTargetFolderId();
            List folderNames = urlNodeSyntaxHelper.getFolderNamesForLayoutNode(request, targetFolderId);
            if (folderNames != null && !folderNames.isEmpty()) {
                url.addPath("f");
                for (String folderName : folderNames) {
                    url.addPath(folderName);
                }
            }
            urlState = UrlState.NORMAL;
            resourceId = null;
        }
        url.addPath(urlState.toLowercaseString());
        if (urlType == UrlType.RESOURCE && resourceId != null) {
            url.addPath(resourceId + "." + urlType.toLowercaseString() + ".uP");
        } else {
            url.addPath(urlType.toLowercaseString() + ".uP");
        }
        Map portalParameters = portalUrlBuilder.getParameters();
        url.addParametersArray("u_", portalParameters);
        boolean statelessUrl = this.statelessUrlStates.contains(urlState);
        for (IPortletUrlBuilder portletUrlBuilder : portletUrlBuilders.values()) {
            this.addPortletUrlData(request, url, urlType, portletUrlBuilder, targetedPortletWindowId, statelessUrl);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generated '" + url + "' from '" + portalUrlBuilder);
        }
        return url.toString();
    }

    protected void addPortletUrlData(HttpServletRequest request, UrlStringBuilder url, UrlType urlType, IPortletUrlBuilder portletUrlBuilder, IPortletWindowId targetedPortletWindowId, boolean statelessUrl) {
        Map parameters;
        String suffixedPortletWindowId;
        String prefixedPortletWindowId;
        IPortletWindowId portletWindowId = portletUrlBuilder.getPortletWindowId();
        boolean targeted = portletWindowId.equals(targetedPortletWindowId);
        IPortletWindow portletWindow = null;
        if (targeted) {
            prefixedPortletWindowId = "";
            suffixedPortletWindowId = "";
        } else {
            String portletWindowIdStr = portletWindowId.toString();
            prefixedPortletWindowId = "_" + portletWindowIdStr;
            suffixedPortletWindowId = portletWindowIdStr + "_";
            url.addParameter("pCa", new String[]{portletWindowIdStr});
            portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
            IPortletWindowId delegationParentId = portletWindow.getDelegationParentId();
            if (delegationParentId != null) {
                url.addParameter("pCd" + prefixedPortletWindowId, new String[]{delegationParentId.getStringId()});
            }
        }
        switch (2.$SwitchMap$org$jasig$portal$url$UrlType[urlType.ordinal()]) {
            case 1: {
                String cacheability = portletUrlBuilder.getCacheability();
                if (cacheability != null) {
                    url.addParameter("pCc" + prefixedPortletWindowId, new String[]{cacheability});
                }
                String resourceId = portletUrlBuilder.getResourceId();
                if (targeted || resourceId == null) break;
                url.addParameter("pCr" + prefixedPortletWindowId, new String[]{resourceId});
                break;
            }
            default: {
                PortletMode portletMode = portletUrlBuilder.getPortletMode();
                if (portletMode != null) {
                    url.addParameter("pCm" + prefixedPortletWindowId, new String[]{portletMode.toString()});
                } else if (targeted && statelessUrl) {
                    portletWindow = portletWindow != null ? portletWindow : this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
                    PortletMode currentPortletMode = portletWindow.getPortletMode();
                    url.addParameter("pCm" + prefixedPortletWindowId, new String[]{currentPortletMode.toString()});
                }
                WindowState windowState = portletUrlBuilder.getWindowState();
                if (windowState == null || targeted && PATH_WINDOW_STATES.contains(windowState)) break;
                url.addParameter("pCs" + prefixedPortletWindowId, new String[]{windowState.toString()});
                break;
            }
        }
        if (portletUrlBuilder.getCopyCurrentRenderParameters()) {
            url.addParameter("pCp" + suffixedPortletWindowId, new String[0]);
        }
        if (!(parameters = portletUrlBuilder.getParameters()).isEmpty()) {
            url.addParametersArray("pP_" + suffixedPortletWindowId, parameters);
        }
    }

    protected UrlState determineUrlState(IPortletWindow portletWindow, IPortletUrlBuilder targetedPortletUrlBuilder) {
        WindowState requestedWindowState = targetedPortletUrlBuilder == null ? null : targetedPortletUrlBuilder.getWindowState();
        return this.determineUrlState(portletWindow, requestedWindowState);
    }

    protected UrlState determineUrlState(IPortletWindow portletWindow, WindowState requestedWindowState) {
        WindowState urlWindowState;
        WindowState currentWindowState = portletWindow.getWindowState();
        WindowState windowState = urlWindowState = requestedWindowState != null ? requestedWindowState : currentWindowState;
        if (WindowState.MAXIMIZED.equals((Object)urlWindowState)) {
            return UrlState.MAX;
        }
        if (IPortletRenderer.DETACHED.equals((Object)urlWindowState)) {
            return UrlState.DETACHED;
        }
        if (IPortletRenderer.EXCLUSIVE.equals((Object)urlWindowState)) {
            return UrlState.EXCLUSIVE;
        }
        if (!WindowState.NORMAL.equals((Object)urlWindowState) && !WindowState.MINIMIZED.equals((Object)urlWindowState)) {
            this.logger.warn("Unknown WindowState '" + urlWindowState + "' specified for portlet window " + portletWindow + ", defaulting to UrlState.NORMAL");
        }
        return UrlState.NORMAL;
    }

    protected String getEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.defaultEncoding;
    }

    protected String getCleanedContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath.length() == 0) {
            return "";
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        if (contextPath.charAt(contextPath.length() - 1) == '/') {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public boolean doesRequestPathReferToSpecificAndDifferentContentVsCanonicalPath(String requestPath, String canonicalPath) {
        if (requestPath == null) {
            String msg = "Argument 'path1' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (canonicalPath == null) {
            String msg = "Argument 'path2' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (LEGACY_URL_PATHS.contains(requestPath) || LEGACY_URL_PATHS.contains(canonicalPath)) {
            return false;
        }
        ContentTuple requestTuple = ContentTuple.parse((String)requestPath);
        if (requestTuple.getFolder() == null && requestTuple.getPortlet() == null) {
            return false;
        }
        ContentTuple canonicalTuple = ContentTuple.parse((String)canonicalPath);
        return !canonicalTuple.equals((Object)requestTuple);
    }
}

