/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PeriodicFlushingBufferedWriter
extends BufferedWriter {
    private final long period;
    private long lastFlush = System.currentTimeMillis();

    public PeriodicFlushingBufferedWriter(long period, Writer out, int sz) {
        super(out, sz);
        this.period = period;
    }

    public PeriodicFlushingBufferedWriter(long period, Writer out) {
        super(out);
        this.period = period;
    }

    private void checkForFlush() throws IOException {
        long now = System.currentTimeMillis();
        if (this.lastFlush <= now + this.period) {
            this.lastFlush = now;
            super.flush();
        }
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.checkForFlush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.checkForFlush();
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        super.write(s, off, len);
        this.checkForFlush();
    }

    @Override
    public void newLine() throws IOException {
        super.newLine();
        this.checkForFlush();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        super.write(cbuf);
        this.checkForFlush();
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
        this.checkForFlush();
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        Writer w = super.append(csq);
        this.checkForFlush();
        return w;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        Writer w = super.append(csq, start, end);
        this.checkForFlush();
        return w;
    }

    @Override
    public Writer append(char c) throws IOException {
        Writer w = super.append(c);
        this.checkForFlush();
        return w;
    }
}

