/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;

public class SqlTransaction {
    private static final Log log = LogFactory.getLog(SqlTransaction.class);

    public static void begin(Connection conn) throws SQLException {
        RDBMServices.setAutoCommit((Connection)conn, (boolean)false);
    }

    public static void commit(Connection conn) throws SQLException {
        RDBMServices.commit((Connection)conn);
        RDBMServices.setAutoCommit((Connection)conn, (boolean)true);
    }

    protected static void logNoTransactionWarning() {
        String msg = "You are running the portal on a database that does not support transactions.  This is not a supported production environment for uPortal.  Sooner or later, your database will become corrupt.";
        log.warn((Object)msg);
    }

    public static void rollback(Connection conn) throws SQLException {
        RDBMServices.rollback((Connection)conn);
        RDBMServices.setAutoCommit((Connection)conn, (boolean)true);
    }

    public static void setAutoCommit(Connection conn, boolean newValue) throws SQLException {
        RDBMServices.setAutoCommit((Connection)conn, (boolean)newValue);
    }
}

