/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jasig.portal.spring.beans.factory.ObjectMapperFactoryBean;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.cache.TaggedCacheEntry;

public final class CacheKey
implements Serializable,
TaggedCacheEntry {
    private static final long serialVersionUID = 1L;
    private static final ObjectWriter WRITER;
    private final String source;
    private final Set<CacheEntryTag> tags;
    private final Serializable[] key;
    @JsonIgnore
    private final int hashCode;

    public static <K extends Serializable, V extends Serializable> CacheKeyBuilder<K, V> builder(String source) {
        return new CacheKeyBuilder(source, null);
    }

    public static CacheKey build(String source, Serializable ... key) {
        return new CacheKey(source, (Serializable[])key.clone(), null);
    }

    public static CacheKey buildTagged(String source, CacheEntryTag tag, Serializable ... key) {
        return new CacheKey(source, (Serializable[])key.clone(), (Set)ImmutableSet.of((Object)tag));
    }

    public static CacheKey build(String source, Collection<? extends Serializable> key) {
        return new CacheKey(source, key.toArray(new Serializable[key.size()]), null);
    }

    public static CacheKey build(String source, Map<? extends Serializable, ? extends Serializable> keyData) {
        Serializable[] key = new Serializable[keyData.size()];
        int mapIndex = 0;
        for (Map.Entry<? extends Serializable, ? extends Serializable> ve : keyData.entrySet()) {
            key[mapIndex++] = new Serializable[]{ve.getKey(), ve.getValue()};
        }
        return new CacheKey(source, key, null);
    }

    CacheKey(String source, Serializable[] key, Set<CacheEntryTag> tags) {
        this.source = source;
        this.key = key;
        this.tags = tags == null ? null : (tags.size() == 1 ? Collections.singleton(tags.iterator().next()) : ImmutableSet.copyOf(tags));
        this.hashCode = this.internalHashCode();
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getSource() {
        return this.source;
    }

    public Set<CacheEntryTag> getTags() {
        return this.tags;
    }

    private int internalHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.key);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (!Arrays.deepEquals(this.key, other.key)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
        }
        catch (JsonMappingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "CacheKey [source=" + this.source + ", key=" + Arrays.toString(this.key) + ", tags=" + this.tags + "]";
    }

    static {
        ObjectMapper mapper;
        try {
            ObjectMapperFactoryBean omfb = new ObjectMapperFactoryBean();
            omfb.afterPropertiesSet();
            mapper = (ObjectMapper)omfb.getObject();
        }
        catch (Exception e) {
            mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
        }
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

