/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class EhcacheManagerBeanConfigurer
implements BeanFactoryPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private boolean skipDuplicates = false;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.cacheManager.getCacheNames()) {
            Ehcache ehcache = this.cacheManager.getEhcache(cacheName);
            this.logger.debug((Object)("Registering Ehcache '" + cacheName + "' with bean factory"));
            if (beanFactory.containsBean(cacheName)) {
                if (this.skipDuplicates) continue;
                throw new BeanCreationException("Duplicate Ehcache " + cacheName + " from CacheManager " + this.cacheManager.getName());
            }
            try {
                beanFactory.registerSingleton(cacheName, (Object)ehcache);
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to register Ehcache " + cacheName + " from CacheManager " + this.cacheManager.getName(), (Throwable)e);
            }
        }
        this.logger.debug((Object)("Registered " + cacheNames.length + " Ehcaches with bean factory"));
    }
}

