/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.TaggedCacheEntry;
import org.jasig.portal.utils.cache.TaggedCacheEntryPurger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tagTrackingCacheEventListener")
public class TagTrackingCacheEventListener
extends CacheEventListenerAdapter
implements TaggedCacheEntryPurger {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<String, Set<Ehcache>> taggedCaches = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final LoadingCache<String, LoadingCache<CacheEntryTag, Set<Object>>> taggedCacheKeys = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public int purgeCacheEntries(CacheEntryTag tag) {
        String tagType = tag.getTagType();
        Set caches = (Set)this.taggedCaches.getIfPresent((Object)tagType);
        if (caches == null || caches.isEmpty()) {
            return 0;
        }
        int purgeCount = 0;
        for (Ehcache cache : caches) {
            Set taggedKeys;
            String cacheName = cache.getName();
            LoadingCache cacheKeys = (LoadingCache)this.taggedCacheKeys.getIfPresent((Object)cacheName);
            if (cacheKeys == null || (taggedKeys = (Set)cacheKeys.asMap().remove(tag)) == null) continue;
            int keyCount = taggedKeys.size();
            purgeCount += keyCount;
            this.logger.debug("Removing {} keys from {} for tag {}", new Object[]{keyCount, cacheName, tag});
            cache.removeAll((Collection)taggedKeys);
        }
        return purgeCount;
    }

    protected Set<CacheEntryTag> getTags(Element element) {
        Object key = element.getObjectKey();
        if (key instanceof TaggedCacheEntry) {
            return ((TaggedCacheEntry)key).getTags();
        }
        Object value = element.getObjectValue();
        if (value instanceof TaggedCacheEntry) {
            return ((TaggedCacheEntry)value).getTags();
        }
        return null;
    }

    protected void putElement(Ehcache cache, Element element) {
        Set tags = this.getTags(element);
        if (tags != null && !tags.isEmpty()) {
            String cacheName = cache.getName();
            Object key = element.getObjectKey();
            LoadingCache cacheKeys = (LoadingCache)this.taggedCacheKeys.getUnchecked((Object)cacheName);
            this.logger.debug("Tracking {} tags in cache {} for key {}", new Object[]{tags.size(), cacheName, key});
            for (CacheEntryTag tag : tags) {
                String tagType = tag.getTagType();
                Set caches = (Set)this.taggedCaches.getUnchecked((Object)tagType);
                caches.add(cache);
                Set taggedKeys = (Set)cacheKeys.getUnchecked((Object)tag);
                taggedKeys.add(key);
            }
        }
    }

    protected void removeElement(Ehcache cache, Element element) {
        String cacheName;
        LoadingCache cacheKeys;
        Set tags = this.getTags(element);
        if (tags != null && !tags.isEmpty() && (cacheKeys = (LoadingCache)this.taggedCacheKeys.getIfPresent((Object)(cacheName = cache.getName()))) != null) {
            Object key = element.getObjectKey();
            this.logger.debug("Tracking removing key cache {} with tag {} : {}", new Object[]{cacheName, tags, key});
            for (CacheEntryTag tag : tags) {
                Set taggedKeys = (Set)cacheKeys.getIfPresent((Object)tag);
                if (taggedKeys == null) continue;
                taggedKeys.remove(key);
            }
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.putElement(cache, element);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.removeElement(cache, element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.removeElement(cache, element);
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.removeElement(cache, element);
    }

    public void notifyRemoveAll(Ehcache cache) {
        String cacheName = cache.getName();
        LoadingCache cacheKeys = (LoadingCache)this.taggedCacheKeys.getIfPresent((Object)cacheName);
        if (cacheKeys != null) {
            this.logger.debug("Tracking remove all tagged keys for cache {}", new Object[]{cacheName});
            cacheKeys.invalidateAll();
        }
    }
}

