/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache.resource;

import java.io.Serializable;
import java.util.Map;
import org.jasig.portal.utils.cache.resource.CachedResource;
import org.jasig.portal.utils.cache.resource.LoadedResource;
import org.springframework.core.io.Resource;

class CachedResourceImpl<T>
implements CachedResource<T> {
    private final Resource resource;
    private final Map<Resource, Long> additionalResources;
    private final T cachedResource;
    private final long lastLoadTime;
    private final Serializable cacheKey;
    private volatile long lastCheckTime;

    public CachedResourceImpl(Resource resource, LoadedResource<T> loadedResource, long lastLoadTime, Serializable cacheKey) {
        this.resource = resource;
        this.cachedResource = loadedResource.getLoadedResource();
        this.additionalResources = loadedResource.getAdditionalResources();
        this.lastLoadTime = lastLoadTime;
        this.lastCheckTime = lastLoadTime;
        this.cacheKey = cacheKey;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<Resource, Long> getAdditionalResources() {
        return this.additionalResources;
    }

    public T getCachedResource() {
        return (T)this.cachedResource;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public void setLastCheckTime(long lastCheckTime) {
        this.lastCheckTime = lastCheckTime;
    }

    public Serializable getCacheKey() {
        return this.cacheKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalResources == null ? 0 : this.additionalResources.hashCode());
        result = 31 * result + (this.cacheKey == null ? 0 : this.cacheKey.hashCode());
        result = 31 * result + (this.cachedResource == null ? 0 : this.cachedResource.hashCode());
        result = 31 * result + (int)(this.lastCheckTime ^ this.lastCheckTime >>> 32);
        result = 31 * result + (int)(this.lastLoadTime ^ this.lastLoadTime >>> 32);
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedResourceImpl other = (CachedResourceImpl)obj;
        if (this.additionalResources == null ? other.additionalResources != null : !this.additionalResources.equals(other.additionalResources)) {
            return false;
        }
        if (this.cacheKey == null ? other.cacheKey != null : !this.cacheKey.equals(other.cacheKey)) {
            return false;
        }
        if (this.cachedResource == null ? other.cachedResource != null : !this.cachedResource.equals(other.cachedResource)) {
            return false;
        }
        if (this.lastCheckTime != other.lastCheckTime) {
            return false;
        }
        if (this.lastLoadTime != other.lastLoadTime) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public String toString() {
        return "CachedResourceImpl [resource=" + this.resource + ", additionalResources=" + this.additionalResources + ", cachedResource=" + this.cachedResource + ", lastLoadTime=" + this.lastLoadTime + ", cacheKey=" + this.cacheKey + ", lastCheckTime=" + this.lastCheckTime + "]";
    }
}

