/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAware;
import org.jasig.portal.utils.Tuple;
import org.jasig.portlet.utils.jdbc.DelayedValidationQueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class DelayedValidationQueryResolverImpl
implements DelayedValidationQueryResolver,
HibernateConfigurationAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Tuple<DataSource, DelayedValidationQueryResolver.ValidationQueryRegistrationHandler>> delayedDataSources = new ArrayList();
    private ConcurrentMap<Class<? extends Dialect>, String> validationQueryMap;
    private String persistenceUnit;
    private DialectResolver dialectResolver;

    public void setValidationQueryMap(Map<Class<? extends Dialect>, String> validationQueryMap) {
        this.validationQueryMap = new ConcurrentHashMap<Class<? extends Dialect>, String>(validationQueryMap);
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public boolean supports(String persistenceUnit) {
        return this.persistenceUnit.equals(persistenceUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(String persistenceUnit, DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration) {
        SessionFactoryServiceRegistry serviceRegistry = hibernateConfiguration.getServiceRegistry();
        List list = this.delayedDataSources;
        synchronized (list) {
            this.dialectResolver = (DialectResolver)serviceRegistry.getService(DialectResolver.class);
            for (Tuple delayedDataSource : this.delayedDataSources) {
                String validationQuery = this.getValidationQuery((DataSource)delayedDataSource.first);
                ((DelayedValidationQueryResolver.ValidationQueryRegistrationHandler)delayedDataSource.second).setValidationQuery(validationQuery);
            }
            this.delayedDataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerValidationQueryCallback(DataSource dataSource, DelayedValidationQueryResolver.ValidationQueryRegistrationHandler validationQueryRegistrationHandler) {
        List list = this.delayedDataSources;
        synchronized (list) {
            if (this.dialectResolver != null) {
                String validationQuery = this.getValidationQuery(dataSource);
                validationQueryRegistrationHandler.setValidationQuery(validationQuery);
            } else {
                this.delayedDataSources.add(new Tuple((Object)dataSource, (Object)validationQueryRegistrationHandler));
            }
        }
    }

    protected String getValidationQuery(DataSource dataSource) {
        Dialect dialect = this.resolveDialect(dataSource);
        if (dialect == null) {
            return null;
        }
        Class<?> dialectType = dialect.getClass();
        return this.resolveValidationQuery(dialectType);
    }

    protected String resolveValidationQuery(Class<? extends Dialect> dialectType) {
        String validationQuery = (String)this.validationQueryMap.get(dialectType);
        if (validationQuery != null) {
            return validationQuery;
        }
        for (Map.Entry validationQueryEntry : this.validationQueryMap.entrySet()) {
            Class dialectEntryType = (Class)validationQueryEntry.getKey();
            if (!dialectEntryType.isAssignableFrom(dialectType)) continue;
            validationQuery = (String)validationQueryEntry.getValue();
            this.validationQueryMap.put(dialectType, validationQuery);
            return validationQuery;
        }
        this.logger.warn("Failed to resolve validation query for Dialect: " + dialectType);
        return null;
    }

    protected Dialect resolveDialect(DataSource dataSource) {
        try {
            return (Dialect)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (DatabaseMetaDataCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (MetaDataAccessException e) {
            this.logger.warn("Failed to resolve Dialect for DataSource " + dataSource + " no validation query will be resolved", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ DialectResolver access$000(DelayedValidationQueryResolverImpl x0) {
        return x0.dialectResolver;
    }
}

