/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;
import org.springframework.util.Assert;
import org.springframework.util.xml.StaxEventContentHandler;
import org.springframework.util.xml.StaxEventLexicalContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class StaxEventLexicalContentHandler
extends StaxEventContentHandler
implements LexicalHandler {
    public static final String EMPTY_SYSTEM_IDENTIFIER = "EMPTY";
    private final XMLEventFactory eventFactory;
    private final XMLEventConsumer eventConsumer;
    private StringBuilder cdata = null;

    public StaxEventLexicalContentHandler(XMLEventConsumer consumer, XMLEventFactory factory) {
        super(consumer, factory);
        Assert.notNull((Object)consumer, (String)"'consumer' must not be null");
        this.eventFactory = factory;
        this.eventConsumer = consumer;
    }

    public StaxEventLexicalContentHandler(XMLEventConsumer consumer) {
        this(consumer, XMLEventFactory.newInstance());
    }

    public void setDocumentLocator(Locator locator) {
        if (locator != null) {
            this.eventFactory.setLocation((Location)new LocatorLocation(locator, null));
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        StringBuilder dtdBuilder = new StringBuilder("<!DOCTYPE ");
        dtdBuilder.append(name);
        if (publicId != null) {
            dtdBuilder.append(" PUBLIC \"").append(publicId).append("\" \"");
            dtdBuilder.append(systemId).append("\"");
        } else if (!EMPTY_SYSTEM_IDENTIFIER.equals(systemId)) {
            dtdBuilder.append(" SYSTEM \"");
            dtdBuilder.append(systemId).append("\"");
        }
        dtdBuilder.append(">");
        DTD event = this.eventFactory.createDTD(dtdBuilder.toString());
        try {
            this.consumeEvent((XMLEvent)event);
        }
        catch (XMLStreamException ex) {
            throw new SAXException("Could not create DTD: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        EntityReference event = this.eventFactory.createEntityReference(name, null);
        try {
            this.consumeEvent((XMLEvent)event);
        }
        catch (XMLStreamException ex) {
            throw new SAXException("Could not create Entity: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.cdata = new StringBuilder();
    }

    @Override
    public void endCDATA() throws SAXException {
        Characters event = this.eventFactory.createCData(this.cdata.toString());
        this.cdata = null;
        try {
            this.consumeEvent((XMLEvent)event);
        }
        catch (XMLStreamException ex) {
            throw new SAXException("Could not create CDATA: " + ex.getMessage(), ex);
        }
    }

    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        if (this.cdata != null) {
            this.cdata.append(ch, start, length);
        } else {
            super.charactersInternal(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        Comment event = this.eventFactory.createComment(new String(ch, start, length));
        try {
            this.consumeEvent((XMLEvent)event);
        }
        catch (XMLStreamException ex) {
            throw new SAXException("Could not create Comment: " + ex.getMessage(), ex);
        }
    }

    private void consumeEvent(XMLEvent event) throws XMLStreamException {
        this.eventConsumer.add(event);
    }
}

