/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain.compare;

import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.builder.CompareToBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBookmarksComparator
implements Comparator<Entry>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static DefaultBookmarksComparator DEFAULT_BOOKMARKS_COMPARATOR = new DefaultBookmarksComparator();

    protected DefaultBookmarksComparator() {
    }

    @Override
    public int compare(Entry e1, Entry e2) {
        return new CompareToBuilder().appendSuper(this.compareFolders(e1, e2)).appendSuper(this.compareEntries(e1, e2)).appendSuper(this.compareBookmarks(e1, e2)).toComparison();
    }

    protected int compareFolders(Entry e1, Entry e2) {
        boolean f1 = e1 instanceof Folder;
        boolean f2 = e2 instanceof Folder;
        if (f1 && !f2) {
            return -1;
        }
        if (!f1 && f2) {
            return 1;
        }
        return 0;
    }

    protected int compareEntries(Entry e1, Entry e2) {
        return new CompareToBuilder().append((Object)e1.getName(), (Object)e2.getName()).append((Object)e1.getNote(), (Object)e2.getNote()).append((Object)e1.getCreated(), (Object)e2.getCreated()).append((Object)e1.getModified(), (Object)e2.getModified()).toComparison();
    }

    protected int compareBookmarks(Entry e1, Entry e2) {
        if (e1 instanceof Bookmark && e2 instanceof Bookmark) {
            Bookmark b1 = (Bookmark)e1;
            Bookmark b2 = (Bookmark)e2;
            return new CompareToBuilder().append((Object)b1.getUrl(), (Object)b2.getUrl()).append(b1.isNewWindow(), b2.isNewWindow()).toComparison();
        }
        return 0;
    }
}

