/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.CollectionFolder;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import edu.wisc.my.portlets.bookmarks.web.BaseEntryFormController;
import java.util.Date;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.BindException;

public class EditCollectionFormController
extends BaseEntryFormController {
    protected Object formBackingObject(PortletRequest request) throws Exception {
        return super.formBackingObject(request);
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        String targetEntryPath = StringUtils.defaultIfEmpty((String)request.getParameter("idPath"), null);
        CollectionFolder commandCollection = (CollectionFolder)command;
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo((Folder)bs, (String)targetParentPath);
        if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
        }
        Folder targetParent = (Folder)targetParentPathInfo.getTarget();
        Map targetChildren = targetParent.getChildren();
        IdPathInfo originalBookmarkPathInfo = FolderUtils.getEntryInfo((Folder)bs, (String)targetEntryPath);
        if (targetParentPathInfo == null || originalBookmarkPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified Bookmark does not exist. BaseFolder='" + bs + "' and idPath='" + targetEntryPath + "'");
        }
        Folder originalParent = originalBookmarkPathInfo.getParent();
        CollectionFolder originalCollection = (CollectionFolder)originalBookmarkPathInfo.getTarget();
        if (targetParent.getId() != originalParent.getId()) {
            Map originalChildren = originalParent.getChildren();
            originalChildren.remove(originalCollection.getId());
            commandCollection.setCreated(originalCollection.getCreated());
            commandCollection.setModified(new Date());
            targetChildren.put(commandCollection.getId(), commandCollection);
        } else {
            originalCollection.setModified(new Date());
            originalCollection.setName(commandCollection.getName());
            originalCollection.setNote(commandCollection.getNote());
            originalCollection.setUrl(commandCollection.getUrl());
            originalCollection.setMinimized(commandCollection.isMinimized());
        }
        this.bookmarkStore.storeBookmarkSet(bs);
    }
}

