/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.service;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portlet.calendar.service.IInitializationService;
import org.jasig.portlet.cas.ICASProxyTicketService;

public class CasProxyInitializationService
implements IInitializationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private int sessionLength = 7200;
    private ICASProxyTicketService proxyTicketService;

    public void setSessionLength(int sessionLength) {
        this.sessionLength = sessionLength;
    }

    public void setProxyTicketService(ICASProxyTicketService proxyTicketService) {
        this.proxyTicketService = proxyTicketService;
    }

    @Override
    public void initialize(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        Assertion receipt = this.proxyTicketService.getProxyTicket(request);
        if (receipt != null) {
            session.setAttribute("CasReceipt", (Object)receipt);
            session.setAttribute("username", (Object)receipt.getPrincipal().getName());
        } else {
            this.log.debug((Object)"no CAS ticket received from portal");
        }
        session.setMaxInactiveInterval(this.sessionLength);
    }
}

