/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.springframework.beans.factory.annotation.Required;

public class CalendarEventsDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private Map<String, DateTimeFormatter> dateFormatters = new ConcurrentHashMap();
    private Map<String, DateTimeFormatter> timeFormatters = new ConcurrentHashMap();

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Calendar getCalendar(ICalendarAdapter adapter, CalendarConfiguration calendarConfig, Interval interval, PortletRequest request) {
        CalendarEventSet eventSet = adapter.getEvents(calendarConfig, interval, request);
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (VEvent event : eventSet.getEvents()) {
            calendar.getComponents().add((Component)event);
        }
        return calendar;
    }

    public Set<CalendarDisplayEvent> getEvents(ICalendarAdapter adapter, CalendarConfiguration calendar, Interval interval, PortletRequest request, DateTimeZone usersConfiguredDateTimeZone) {
        CalendarEventSet eventSet = adapter.getEvents(calendar, interval, request);
        String tzKey = eventSet.getKey().concat(usersConfiguredDateTimeZone.getID());
        Element cachedElement = this.cache.get((Serializable)((Object)tzKey));
        if (cachedElement != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving JSON timezone-aware event set from cache, key:" + tzKey));
            }
            Set jsonEvents = (Set)((Object)cachedElement.getValue());
            return jsonEvents;
        }
        HashSet<CalendarDisplayEvent> displayEvents = new HashSet<CalendarDisplayEvent>();
        for (VEvent event : eventSet.getEvents()) {
            try {
                displayEvents.addAll(this.getDisplayEvents(event, interval, usersConfiguredDateTimeZone));
            }
            catch (ParseException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
            catch (URISyntaxException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
        }
        cachedElement = new Element((Object)tzKey, displayEvents);
        long currentTime = System.currentTimeMillis();
        if (eventSet.getExpirationTime() > currentTime) {
            long timeToLiveInMilliseconds = eventSet.getExpirationTime() - currentTime;
            int timeToLiveInSeconds = (int)timeToLiveInMilliseconds / 1000;
            cachedElement.setTimeToLive(timeToLiveInSeconds);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Storing JSON timezone-aware event set to cache, key:" + tzKey + " with expiration in " + timeToLiveInSeconds + " seconds to" + " coincide with adapter's cache expiration time"));
            }
        }
        this.cache.put(cachedElement);
        return displayEvents;
    }

    protected Set<CalendarDisplayEvent> getDisplayEvents(VEvent e, Interval interval, DateTimeZone usersConfiguredDateTimeZone) throws IOException, URISyntaxException, ParseException {
        DateTime eventStart;
        VEvent event = (VEvent)e.copy();
        DateTime eventEnd = null;
        if (event.getStartDate().getTimeZone() == null && !event.getStartDate().isUtc()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Identified event " + event.getSummary() + " as a floating event"));
            }
            int offset = usersConfiguredDateTimeZone.getOffset(event.getStartDate().getDate().getTime());
            eventStart = new DateTime(event.getStartDate().getDate().getTime() - (long)offset, usersConfiguredDateTimeZone);
            if (event.getEndDate() != null) {
                eventEnd = new DateTime(event.getEndDate().getDate().getTime() - (long)offset, usersConfiguredDateTimeZone);
            }
        } else {
            eventStart = new DateTime((Object)event.getStartDate().getDate(), usersConfiguredDateTimeZone);
            if (event.getEndDate() != null) {
                eventEnd = new DateTime((Object)event.getEndDate().getDate(), usersConfiguredDateTimeZone);
            }
        }
        if (eventEnd == null) {
            eventEnd = eventStart;
        }
        Object firstDayToProcess = interval.contains(event.getStartDate().getDate().getTime()) ? event.getStartDate().getDate() : interval.getStart().toDate();
        DateMidnight startOfTheSpecificDay = new DateMidnight(firstDayToProcess, usersConfiguredDateTimeZone);
        DateMidnight endOfTheSpecificDay = startOfTheSpecificDay.plusDays(1);
        DateTimeFormatter df = this.getDateFormatter(usersConfiguredDateTimeZone);
        DateTimeFormatter tf = this.getTimeFormatter(usersConfiguredDateTimeZone);
        HashSet<CalendarDisplayEvent> events = new HashSet<CalendarDisplayEvent>();
        do {
            Interval theSpecificDay = new Interval(startOfTheSpecificDay.getMillis(), endOfTheSpecificDay.getMillis(), usersConfiguredDateTimeZone);
            Interval eventInterval = new Interval((ReadableInstant)eventStart, (ReadableInstant)eventEnd);
            CalendarDisplayEvent json = new CalendarDisplayEvent(event, eventInterval, theSpecificDay, df, tf);
            if (theSpecificDay.getStart().isEqual((ReadableInstant)eventStart)) {
                events.add(json);
            } else if (theSpecificDay.overlaps((ReadableInterval)eventInterval)) {
                events.add(json);
            }
            startOfTheSpecificDay = startOfTheSpecificDay.plusDays(1);
            endOfTheSpecificDay = endOfTheSpecificDay.plusDays(1);
        } while (startOfTheSpecificDay.isBefore((ReadableInstant)eventEnd) && interval.contains((ReadableInstant)startOfTheSpecificDay));
        return events;
    }

    protected DateTimeFormatter getDateFormatter(DateTimeZone timezone) {
        if (this.dateFormatters.containsKey(timezone.getID())) {
            return (DateTimeFormatter)this.dateFormatters.get(timezone.getID());
        }
        DateTimeFormatter df = new DateTimeFormatterBuilder().appendDayOfWeekText().appendLiteral(" ").appendMonthOfYearText().appendLiteral(" ").appendDayOfMonth(1).toFormatter().withZone(timezone);
        this.dateFormatters.put(timezone.getID(), df);
        return df;
    }

    protected DateTimeFormatter getTimeFormatter(DateTimeZone timezone) {
        if (this.timeFormatters.containsKey(timezone.getID())) {
            return (DateTimeFormatter)this.timeFormatters.get(timezone.getID());
        }
        DateTimeFormatter tf = new DateTimeFormatterBuilder().appendClockhourOfHalfday(1).appendLiteral(":").appendMinuteOfHour(2).appendLiteral(" ").appendHalfdayOfDayText().toFormatter().withZone(timezone);
        this.timeFormatters.put(timezone.getID(), tf);
        return tf;
    }
}

