/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.service.IInitializationService;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Required;

public class SessionSetupInitializationService
implements IInitializationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String USERNAME_KEY = "username";
    private CalendarStore calendarStore;
    private int defaultDays = 7;
    private String userToken = null;

    @Override
    public void initialize(PortletRequest request) {
        PortletSession session = request.getPortletSession(true);
        String subscribeId = null;
        if (this.userToken == null || this.userToken.equalsIgnoreCase("")) {
            subscribeId = request.getRemoteUser();
        } else {
            Map userinfo = (Map)request.getAttribute("javax.portlet.userinfo");
            subscribeId = (String)userinfo.get(this.userToken);
        }
        if (subscribeId == null) {
            subscribeId = "guest";
        }
        session.setAttribute(USERNAME_KEY, (Object)subscribeId);
        List<String> allRoles = this.calendarStore.getUserRoles();
        HashSet<String> userRoles = new HashSet<String>();
        for (String role : allRoles) {
            if (!request.isUserInRole(role)) continue;
            userRoles.add(role);
        }
        session.setAttribute("userRoles", userRoles);
        session.setAttribute("isAdmin", (Object)request.isUserInRole("calendarAdmin"), 1);
        this.calendarStore.initCalendar(subscribeId, userRoles);
        HashMap hiddenCalendars = new HashMap();
        session.setAttribute("hiddenCalendars", hiddenCalendars);
        PortletPreferences prefs = request.getPreferences();
        String timezone = prefs.getValue("timezone", "America/New_York");
        session.setAttribute("timezone", (Object)timezone);
        DateMidnight start = new DateMidnight(DateTimeZone.forID((String)timezone));
        session.setAttribute("startDate", (Object)start);
        String prefDays = prefs.getValue("days", String.valueOf(this.defaultDays));
        int tempDays = Integer.parseInt(prefDays);
        session.setAttribute("days", (Object)tempDays);
        session.setAttribute("initialized", (Object)"true");
    }

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public void setDefaultDays(int defaultDays) {
        this.defaultDays = defaultDays;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }
}

