/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.url;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.url.IUrlCreator;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class StringTemplateUrlCreatorImpl
implements IUrlCreator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String USERNAME_TOKEN = "@USERNAME@";
    private final String START_DATE_TOKEN = "@STARTDATE@";
    private final String END_DATE_TOKEN = "@ENDDATE@";
    private final String URL_ENCODING = "UTF-8";
    private final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    private Map<String, DateTimeFormatter> dateFormatters = new ConcurrentHashMap<String, DateTimeFormatter>();

    @Override
    public String constructUrl(CalendarConfiguration configuration, Interval interval, PortletRequest request) {
        PortletSession session = request.getPortletSession();
        if (session == null) {
            throw new CalendarException();
        }
        String username = (String)session.getAttribute("username");
        return this.constructUrlInternal(configuration, interval, username);
    }

    public String constructUrlInternal(CalendarConfiguration configuration, Interval interval, String username) {
        String url = configuration.getCalendarDefinition().getParameters().get("url");
        try {
            url = url.replace("@USERNAME@", URLEncoder.encode(username, "UTF-8"));
            if (url.contains("@STARTDATE@") || url.contains("@ENDDATE@")) {
                String urlDateFormat = configuration.getCalendarDefinition().getParameters().get("urlDateFormat");
                if (urlDateFormat == null) {
                    urlDateFormat = "yyyyMMdd";
                }
                String startString = URLEncoder.encode(this.getDateFormatter(urlDateFormat).print((ReadableInstant)interval.getStart()), "UTF-8");
                url = url.replace("@STARTDATE@", startString);
                String endString = URLEncoder.encode(this.getDateFormatter(urlDateFormat).print((ReadableInstant)interval.getEnd()), "UTF-8");
                url = url.replace("@ENDDATE@", endString);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
        }
        return url;
    }

    protected DateTimeFormatter getDateFormatter(String format) {
        if (this.dateFormatters.containsKey(format)) {
            return this.dateFormatters.get(format);
        }
        DateTimeFormatter df = new DateTimeFormatterBuilder().appendPattern(format).toFormatter();
        this.dateFormatters.put(format, df);
        return df;
    }
}

