/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.dao;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.springframework.beans.factory.annotation.Required;

public class HibernateCalendarSetDao
implements ICalendarSetDao {
    private CalendarStore calendarStore;

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public CalendarSet<?> getCalendarSet(PortletRequest request) {
        String username = this.getUsername(request);
        List cals = this.calendarStore.getCalendarConfigurations(username);
        HashSet calendars = new HashSet();
        calendars.addAll(cals);
        CalendarSet set = new CalendarSet();
        set.setConfigurations(calendars);
        return set;
    }

    public List<PredefinedCalendarConfiguration> getAvailablePredefinedCalendarConfigurations(PortletRequest request) {
        String username = this.getUsername(request);
        return this.calendarStore.getPredefinedCalendarConfigurations(username, false);
    }

    private String getUsername(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        String rslt = (String)session.getAttribute("username");
        return rslt;
    }
}

