/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.controller;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.web.portlet.mvc.AbstractAjaxController;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxSingleFeedNewsController
extends AbstractAjaxController {
    private static Log log = LogFactory.getLog(AjaxSingleFeedNewsController.class);

    protected Map<Object, Object> handleAjaxRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        log.debug((Object)"handleAjaxRequestInternal (AjaxNewsController)");
        PortletPreferences prefs = request.getPreferences();
        String url = prefs.getValue("url", null);
        String name = prefs.getValue("name", null);
        int maxStories = Integer.parseInt(prefs.getValue("maxStories", "10"));
        String className = prefs.getValue("className", null);
        JSONObject json = new JSONObject();
        JSONArray jsonFeeds = new JSONArray();
        JSONObject item = new JSONObject();
        item.put((Object)"id", (Object)1);
        item.put((Object)"name", (Object)name);
        jsonFeeds.add((Object)item);
        json.put((Object)"feeds", (Object)jsonFeeds);
        json.put((Object)"activeFeed", (Object)1);
        NewsDefinition feedDef = new NewsDefinition(new Long(1L), className, name);
        feedDef.addParameter("url", url);
        NewsConfiguration feedConfig = new NewsConfiguration();
        feedConfig.setNewsDefinition(feedDef);
        feedConfig.setId(new Long(1L));
        SyndFeed feed = null;
        ApplicationContext ctx = this.getApplicationContext();
        ArrayList errors = new ArrayList();
        try {
            INewsAdapter adapter = (INewsAdapter)ctx.getBean(className);
            feed = adapter.getSyndFeed(feedConfig, (PortletRequest)request);
            log.debug((Object)"Got feed from adapter");
            if (feed.getEntries().isEmpty()) {
                json.put((Object)"message", (Object)"<p>No news.</p>");
            } else {
                JSONObject jsonFeed = new JSONObject();
                jsonFeed.put((Object)"link", (Object)feed.getLink());
                jsonFeed.put((Object)"title", (Object)feed.getTitle());
                jsonFeed.put((Object)"author", (Object)feed.getAuthor());
                jsonFeed.put((Object)"copyright", (Object)feed.getCopyright());
                JSONArray jsonEntries = new JSONArray();
                ListIterator i = feed.getEntries().listIterator();
                while (i.hasNext() && i.nextIndex() < maxStories) {
                    SyndEntry entry = (SyndEntry)i.next();
                    JSONObject jsonEntry = new JSONObject();
                    jsonEntry.put((Object)"link", (Object)entry.getLink());
                    jsonEntry.put((Object)"title", (Object)entry.getTitle());
                    jsonEntry.put((Object)"description", (Object)entry.getDescription().getValue());
                    jsonEntries.add((Object)jsonEntry);
                }
                jsonFeed.put((Object)"entries", (Object)jsonEntries);
                json.put((Object)"feed", (Object)jsonFeed);
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            log.error((Object)("News class instance could not be found: " + ex.getMessage()));
            json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (NewsException ex) {
            log.warn((Object)ex);
            json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (Exception ex) {
            log.error((Object)ex);
            json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        log.debug((Object)"forwarding to /ajaxFeedList");
        HashMap<Object, Object> model = new HashMap<Object, Object>();
        model.put("json", json);
        log.debug((Object)json);
        return model;
    }
}

