/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.mvc.NewsDefinitionForm;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class EditNewsDefinitionController
extends SimpleFormController {
    private static Log log = LogFactory.getLog(EditNewsDefinitionController.class);
    private NewsStore newsStore;

    protected Object formBackingObject(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedNewsDefinition definition = this.newsStore.getPredefinedNewsDefinition(definitionId);
                NewsDefinitionForm command = new NewsDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                return command;
            }
            return new NewsDefinitionForm();
        }
        return new NewsDefinitionForm();
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        NewsDefinitionForm form = (NewsDefinitionForm)command;
        PredefinedNewsDefinition definition = null;
        definition = form.getId() > -1L ? this.newsStore.getPredefinedNewsDefinition(form.getId()) : new PredefinedNewsDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setParameters(form.getParameters());
        this.newsStore.storeNewsDefinition((NewsDefinition)definition);
        response.setRenderParameter("action", "administration");
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

