/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;

public class UnsharedNewsSetServiceImpl
implements NewsSetResolvingService {
    private static Log log = LogFactory.getLog(UnsharedNewsSetServiceImpl.class);
    private NewsStore newsStore;

    public NewsSet getNewsSet(Long id, ActionRequest request) {
        NewsSet set = null;
        PortletSession session = request.getPortletSession();
        if (id < 0L) {
            log.debug((Object)"Creating and saving new set.");
            set = this.createNewsSet(request);
        } else {
            log.debug((Object)("Retrieving news set " + id));
            set = this.newsStore.getNewsSet(id);
        }
        if (session.getAttribute("setId") == null) {
            Set roles = (Set)session.getAttribute("userRoles", 2);
            this.newsStore.initNews(set, roles);
            this.newsStore.storeNewsSet(set);
            session.setAttribute("setId", (Object)set.getId(), 2);
        }
        return set;
    }

    private NewsSet createNewsSet(ActionRequest request) {
        NewsSet set = new NewsSet();
        set.setUserId(request.getRemoteUser());
        this.newsStore.storeNewsSet(set);
        return set;
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

