/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.adapter;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.adapter.AbstractNewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.processor.RomeNewsProcessorImpl;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class RomeAdapter
extends AbstractNewsAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private RomeNewsProcessorImpl processor;
    private String proxyHost = null;
    private String proxyPort = null;
    private Cache cache;

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProcessor(RomeNewsProcessorImpl processor) {
        this.processor = processor;
    }

    public NewsFeed getSyndFeed(NewsConfiguration config, PortletRequest request) throws NewsException {
        NewsFeed feed = null;
        PortletPreferences prefs = request.getPreferences();
        String titlePolicy = prefs.getValue("titlePolicy", "antisamy-textonly");
        String descriptionPolicy = prefs.getValue("descriptionPolicy", "antisamy-textonly");
        String url = (String)config.getNewsDefinition().getParameters().get("url");
        if (url == null) {
            throw new IllegalArgumentException("The url parameter was not found; this is a required portlet preference.");
        }
        String url2 = (String)config.getNewsDefinition().getParameters().get("url2");
        String key = this.getCacheKey(url);
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            this.log.debug((Object)"Cache miss");
            if (url2 == null) {
                feed = this.getSyndFeed(url, titlePolicy, descriptionPolicy);
            } else {
                try {
                    feed = this.getSyndFeed(url, titlePolicy, descriptionPolicy);
                }
                catch (NewsException ex) {
                    this.log.warn((Object)"Failed to load feed at the primary URL so trying URL2", (Throwable)ex);
                }
                if (feed == null) {
                    feed = this.getSyndFeed(url2, titlePolicy, descriptionPolicy);
                }
            }
            cachedElement = new Element((Serializable)((Object)key), (Serializable)feed);
            this.cache.put(cachedElement);
        } else {
            this.log.debug((Object)"Cache hit");
            feed = (NewsFeed)cachedElement.getValue();
        }
        return feed;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NewsFeed getSyndFeed(String url, String titlePolicy, String descriptionPolicy) throws NewsException {
        NewsFeed newsFeed;
        GetMethod get;
        block18: {
            HttpClient client = new HttpClient();
            get = null;
            NewsFeed feed = null;
            String proxyHost = null;
            String proxyPort = null;
            InputStream in = null;
            try {
                this.log.debug((Object)("Retrieving feed " + url));
                if (StringUtils.isBlank((String)this.proxyHost) && StringUtils.isBlank((String)this.proxyPort)) {
                    this.log.trace((Object)"Checking for proxy configuration from system properties...");
                    proxyHost = System.getProperty("http.proxyHost");
                    proxyPort = System.getProperty("http.proxyPort");
                    if (StringUtils.isBlank((String)proxyHost) && StringUtils.isBlank((String)proxyPort)) {
                        this.log.debug((Object)"Found proxy configuration from system properties");
                    }
                }
                if (!StringUtils.isBlank(proxyHost) && !StringUtils.isBlank(proxyPort)) {
                    client.getHostConfiguration().setProxy(proxyHost, Integer.valueOf(proxyPort).intValue());
                    this.log.debug((Object)("Using proxy configuration to retrieve news feeds: " + proxyHost + ":" + proxyPort));
                } else {
                    this.log.debug((Object)"No proxy configuration is set. Proceeding normally...");
                }
                get = new GetMethod(url);
                int rc = client.executeMethod((HttpMethod)get);
                if (rc != 200) {
                    this.log.warn((Object)("HttpStatus for " + url + ":" + rc));
                }
                if ((in = get.getResponseBodyAsStream()) != null) {
                    feed = this.processor.getFeed(in, titlePolicy, descriptionPolicy);
                } else {
                    this.log.warn((Object)("Feed response not available or cannot be read. URL=" + url));
                }
                newsFeed = feed;
                if (in == null) break block18;
            }
            catch (PolicyException e) {
                try {
                    this.log.warn((Object)"Error fetching feed", (Throwable)e);
                    throw new NewsException("Error fetching feed", (Throwable)e);
                    catch (ScanException e2) {
                        this.log.warn((Object)"Error fetching feed", (Throwable)e2);
                        throw new NewsException("Error fetching feed", (Throwable)e2);
                    }
                    catch (HttpException e3) {
                        this.log.warn((Object)"Error fetching feed", (Throwable)e3);
                        throw new NewsException("Error fetching feed", (Throwable)e3);
                    }
                    catch (IOException e4) {
                        this.log.warn((Object)"Error fetching feed", (Throwable)e4);
                        throw new NewsException("Error fetching feed", (Throwable)e4);
                    }
                    catch (FeedException e5) {
                        this.log.warn((Object)"Error parsing feed: ", (Throwable)e5);
                        throw new NewsException("Error parsing feed", (Throwable)e5);
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                    if (get != null) {
                        get.releaseConnection();
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (get != null) {
            get.releaseConnection();
        }
        return newsFeed;
    }

    private String getCacheKey(String url) {
        StringBuffer key = new StringBuffer();
        key.append("RomeFeed.");
        key.append(url);
        return key.toString();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

