/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.yahoo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.weather.InvalidConfigurationException;
import org.jasig.portlet.weather.QuietUrlCodec;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.dao.IWeatherDao;
import org.jasig.portlet.weather.dao.yahoo.IYahooLocationParsingService;
import org.jasig.portlet.weather.dao.yahoo.IYahooWeatherParsingService;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooWeatherDaoImpl
implements IWeatherDao,
DisposableBean,
InitializingBean {
    private static final String FIND_URL = "http://where.yahooapis.com/v1/places.q(@QUERY@);count=10?appid=@KEY@";
    private static final String WEATHER_URL = "http://weather.yahooapis.com/forecastrss?w=@LOCATION@&u=@UNIT@";
    private static final String ERR_API_MISSING_KEY = "exception.missing.APIKey";
    private static final String ERR_GENERAL_KEY = "exception.generalError.title";
    private IYahooWeatherParsingService weatherParsingService;
    private IYahooLocationParsingService locationParsingService;
    private String key;
    private MessageSource messageSource;
    private final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private final HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private int timesToRetry = 5;

    public void setWeatherParsingService(IYahooWeatherParsingService parser) {
        this.weatherParsingService = parser;
    }

    public void setLocationParsingService(IYahooLocationParsingService parser) {
        this.locationParsingService = parser;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTimesToRetry(int timesToRetry) {
        this.timesToRetry = timesToRetry;
    }

    public void afterPropertiesSet() throws Exception {
        HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setConnectionTimeout(this.connectionTimeout);
        params.setSoTimeout(this.readTimeout);
        params.setParameter("http.method.retry-handler", (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void destroy() throws Exception {
        this.connectionManager.shutdown();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Location> find(String location) {
        List list;
        if (this.key == null || this.key.length() == 0) {
            DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(new String[]{ERR_API_MISSING_KEY, ERR_GENERAL_KEY});
            throw new InvalidConfigurationException(this.messageSource.getMessage((MessageSourceResolvable)resolvable, Locale.getDefault()));
        }
        String url = FIND_URL.replace("@KEY@", this.key).replace("@QUERY@", QuietUrlCodec.encode((String)location, (String)"UTF-8"));
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            List locations;
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            list = locations = this.locationParsingService.parseLocations(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return list;
    }

    public Weather getWeather(String locationCode, TemperatureUnit unit) {
        String yahooweatherUrl = WEATHER_URL.replace("@LOCATION@", QuietUrlCodec.encode((String)locationCode, (String)"UTF-8")).replace("@UNIT@", TemperatureUnit.C.equals((Object)unit) ? "c" : "f");
        return (Weather)this.getAndDeserialize(yahooweatherUrl);
    }

    public String getWeatherProviderName() {
        return "Yahoo! Weather";
    }

    public String getWeatherProviderLink() {
        return "http://weather.yahoo.com";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getAndDeserialize(String url) {
        Weather weather;
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            weather = this.weatherParsingService.parseWeather(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return weather;
    }

    static /* synthetic */ int access$000(YahooWeatherDaoImpl x0) {
        return x0.timesToRetry;
    }
}

