/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache;

import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class CacheWriter
extends Writer {
    private Writer out;
    private final StringWriter cacheBuffer = new StringWriter(1024);
    private final CacheEntry entryBase;
    private final String key;
    private final PageCache cache;
    private final boolean persistData;

    public CacheWriter(Writer out, CacheEntry entryBase, PageCache cache, String cacheKey, boolean persistData) {
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        if (cacheKey == null) {
            throw new IllegalArgumentException("cacheKey cannot be null");
        }
        this.out = out;
        this.entryBase = entryBase;
        this.key = cacheKey;
        this.cache = cache;
        this.persistData = persistData;
    }

    public void close() throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.entryBase.setContent(this.cacheBuffer.toString());
        this.cache.cachePage(this.key, this.entryBase, this.persistData);
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.out.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(cbuf, off, len);
        this.out.write(cbuf, off, len);
    }

    public Writer append(char c) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.append(c);
        this.out.append(c);
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.append(csq, start, end);
        this.out.append(csq, start, end);
        return this;
    }

    public Writer append(CharSequence csq) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.append(csq);
        this.out.append(csq);
        return this;
    }

    public void write(char[] cbuf) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(cbuf);
        this.out.write(cbuf);
    }

    public void write(int c) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(c);
        this.out.write(c);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(str, off, len);
        this.out.write(str, off, len);
    }

    public void write(String str) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(str);
        this.out.write(str);
    }
}

