/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.security;

import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;

public class CasAuthenticationHandler {
    public static final String CAS_AUTHENTICATED_SESSION_FLAG = "edu.wisc.my.webproxy.beans.security.CasAuthenticationHandler.CAS_AUTHENTICATED_SESSION_FLAG";
    private static final Log log = LogFactory.getLog(CasAuthenticationHandler.class);
    protected Cas20ProxyTicketValidator ticketValidator;
    protected String myService;

    public Cas20ProxyTicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(Cas20ProxyTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public String getMyService() {
        return this.myService;
    }

    public void setMyService(String myService) {
        this.myService = myService;
    }

    public String authenticate(PortletRequest request, String myProxyTicket) {
        PortletPreferences myPreferences = request.getPreferences();
        String service = myPreferences.getValue(GeneralConfigImpl.BASE_URL, null);
        Assertion assertion = null;
        try {
            assertion = this.ticketValidator.validate(myProxyTicket, this.myService);
        }
        catch (TicketValidationException ex) {
            log.error((Object)("Unable to validate my proxy ticket: " + myProxyTicket + " for service: " + this.myService), (Throwable)ex);
            return null;
        }
        String proxyTicket = assertion.getPrincipal().getProxyTicketFor(service);
        String newServiceUrl = service + "?ticket=" + proxyTicket;
        return newServiceUrl;
    }
}

