/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cas.test.mvc;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public final class ProxyCasController {
    private Log log = LogFactory.getLog(ProxyCasController.class);
    private TicketValidator validator;
    private String serviceUrl = "http://localhost:8080/cas-proxy-test-portlet";
    private String proxyTicketKey = "casProxyTicket";

    @Autowired(required=true)
    public void setTicketValidator(TicketValidator validator) {
        this.validator = validator;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @RequestMapping
    public ModelAndView validateProxyCas(RenderRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String proxyTicket = (String)userInfo.get(this.proxyTicketKey);
        if (proxyTicket == null) {
            model.put("success", false);
            model.put("message", "No proxy ticket in UserInfo map");
            return new ModelAndView("/proxyPortlet", model);
        }
        try {
            Assertion assertion = this.validator.validate(proxyTicket, this.serviceUrl);
            String proxyTicket2 = assertion.getPrincipal().getProxyTicketFor("notarealsite");
            model.put("success", true);
        }
        catch (TicketValidationException e) {
            this.log.error((Object)"Exception attempting to validate proxy ticket", (Throwable)e);
            model.put("success", false);
            model.put("message", "Unable to validate proxy ticket");
        }
        return new ModelAndView("/proxyPortlet", model);
    }
}

