/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao;

import java.io.Serializable;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;

public final class CachingCoursesDao
implements ICoursesDao {
    private static final String UNAUTHENTICATED_USER_TERMLIST_CACHE_KEY = "CachingCoursesDao.UNAUTHENTICATED_USER_TERMLIST_CACHE_KEY";
    private final Log log = LogFactory.getLog(this.getClass());
    private ICoursesDao enclosedCoursesDao;
    private Cache termListCache;
    private Cache coursesByTermCache;

    public void setEnclosedCoursesDao(ICoursesDao enclosedCoursesDao) {
        this.enclosedCoursesDao = enclosedCoursesDao;
    }

    public void setTermListCache(Cache termListCache) {
        this.termListCache = termListCache;
    }

    public void setCoursesByTermCache(Cache coursesByTermCache) {
        this.coursesByTermCache = coursesByTermCache;
    }

    @Override
    public TermList getTermList(PortletRequest req) {
        TermList rslt = null;
        String cacheKey = this.getTermListCacheKey(req);
        Element m = this.termListCache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            rslt = (TermList)m.getValue();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Fetching new TermList from enclosedCoursesDao for user '" + req.getRemoteUser() + "'"));
            }
            rslt = this.enclosedCoursesDao.getTermList(req);
            m = new Element((Serializable)((Object)cacheKey), (Serializable)rslt);
            this.termListCache.put(m);
        }
        return rslt;
    }

    @Override
    public CoursesByTerm getCoursesByTerm(PortletRequest req, String termCode) {
        CoursesByTerm rslt = null;
        String cacheKey = this.getCoursesByTermCacheKey(req, termCode);
        if (cacheKey == null) {
            rslt = new CoursesByTerm();
            rslt.setTermCode(termCode);
            return rslt;
        }
        Element m = this.coursesByTermCache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            rslt = (CoursesByTerm)m.getValue();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Fetching new CoursesByTerm from enclosedCoursesDao for user '" + req.getRemoteUser() + "'"));
            }
            rslt = this.enclosedCoursesDao.getCoursesByTerm(req, termCode);
            m = new Element((Serializable)((Object)cacheKey), (Serializable)rslt);
            this.coursesByTermCache.put(m);
        }
        return rslt;
    }

    private String getTermListCacheKey(PortletRequest req) {
        String rslt = req.getRemoteUser() != null ? req.getRemoteUser() : UNAUTHENTICATED_USER_TERMLIST_CACHE_KEY;
        return rslt;
    }

    private String getCoursesByTermCacheKey(PortletRequest req, String termCode) {
        String username = req.getRemoteUser();
        if (username != null) {
            return username.concat("|").concat(termCode);
        }
        return null;
    }
}

