/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.portlet.courses.dao.ICourseOfferingDao;
import org.jasig.portlet.courses.model.catalog.xml.CourseList;
import org.jasig.portlet.courses.model.catalog.xml.CourseSection;
import org.jasig.portlet.courses.model.catalog.xml.Department;
import org.jasig.portlet.courses.model.catalog.xml.DepartmentList;
import org.jasig.portlet.courses.model.catalog.xml.FullCourseOffering;
import org.jasig.portlet.courses.model.catalog.xml.School;
import org.jasig.portlet.courses.model.catalog.xml.SchoolList;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class HttpClientCourseOfferingDaoImpl
implements ICourseOfferingDao {
    private RestTemplate restTemplate;
    private Cache cache;
    protected final String SCHOOL_LIST_KEY = "schoolList";
    protected final String TERM_LIST_KEY = "termList";
    protected final String DEPARTMENT_LIST_KEY = "departmentList";
    protected final String COURSE_LIST_KEY = "courseList";
    @Value(value="http://localhost:8080/CoursesPortlet/data/terms/{school}.xml")
    private String termListUrl;
    @Value(value="http://localhost:8080/CoursesPortlet/data/schools.xml")
    private String schoolListUrl;
    @Value(value="http://localhost:8080/CoursesPortlet/data/departments/{school}/{term}.xml")
    private String departmentListUrl;
    @Value(value="http://localhost:8080/CoursesPortlet/data/courses/{school}/{term}/{department}.xml")
    private String courseListUrl;
    @Value(value="http://localhost:8080/CoursesPortlet/data/courses/{school}/{term}/{department}/{course}.xml")
    private String courseUrl;

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Autowired(required=true)
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setTermListUrl(String termListUrl) {
        this.termListUrl = termListUrl;
    }

    public void setSchoolListUrl(String schoolListUrl) {
        this.schoolListUrl = schoolListUrl;
    }

    public void setDepartmentListUrl(String departmentListUrl) {
        this.departmentListUrl = departmentListUrl;
    }

    public void setCourseListUrl(String courseListUrl) {
        this.courseListUrl = courseListUrl;
    }

    public void setCourseUrl(String courseUrl) {
        this.courseUrl = courseUrl;
    }

    @Override
    public TermList getTerms(String schoolCode) {
        String cacheKey = "termList".concat(schoolCode);
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            return (TermList)element.getValue();
        }
        TermList terms = (TermList)this.restTemplate.getForObject(this.termListUrl, TermList.class, Collections.singletonMap("school", schoolCode));
        this.cache.put(new Element((Serializable)((Object)cacheKey), (Serializable)terms));
        return terms;
    }

    @Override
    public Term getCurrentTerm(String schoolCode) {
        TermList termList = this.getTerms(schoolCode);
        for (Term term : termList.getTerms()) {
            if (!term.isCurrent()) continue;
            return term;
        }
        if (termList.getTerms().size() > 0) {
            return (Term)termList.getTerms().get(0);
        }
        return null;
    }

    @Override
    public SchoolList getSchools() {
        Element element = this.cache.get((Serializable)((Object)"schoolList"));
        if (element != null) {
            return (SchoolList)element.getValue();
        }
        SchoolList schools = (SchoolList)this.restTemplate.getForObject(this.schoolListUrl, SchoolList.class, new Object[0]);
        this.cache.put(new Element((Serializable)((Object)"schoolList"), (Serializable)schools));
        return schools;
    }

    @Override
    public School getSchool(String schoolCode) {
        SchoolList schoolList = this.getSchools();
        for (School school : schoolList.getSchools()) {
            if (!school.getCode().equals(schoolCode)) continue;
            return school;
        }
        return null;
    }

    @Override
    public DepartmentList getDepartments(String schoolCode, String termCode) {
        String cacheKey = "departmentList".concat(schoolCode).concat(termCode);
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            return (DepartmentList)element.getValue();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("school", schoolCode);
        params.put("term", termCode);
        DepartmentList departments = (DepartmentList)this.restTemplate.getForObject(this.departmentListUrl, DepartmentList.class, params);
        this.cache.put(new Element((Serializable)((Object)cacheKey), (Serializable)departments));
        return departments;
    }

    @Override
    public Department getDepartment(String schoolCode, String departmentCode, String termCode) {
        DepartmentList departmentList = this.getDepartments(schoolCode, termCode);
        for (Department department : departmentList.getDepartments()) {
            if (!department.getCode().equals(departmentCode)) continue;
            return department;
        }
        return null;
    }

    @Override
    public CourseList getCourseOfferings(String schoolCode, String departmentCode, String termCode) {
        String cacheKey = "courseList".concat(schoolCode).concat(departmentCode).concat(termCode);
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            return (CourseList)element.getValue();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("school", schoolCode);
        params.put("term", termCode);
        params.put("department", departmentCode);
        CourseList courses = (CourseList)this.restTemplate.getForObject(this.courseListUrl, CourseList.class, params);
        this.cache.put(new Element((Serializable)((Object)cacheKey), (Serializable)courses));
        return courses;
    }

    @Override
    public FullCourseOffering getCourseOffering(String courseCode, String termCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("term", termCode);
        params.put("course", courseCode);
        FullCourseOffering course = (FullCourseOffering)this.restTemplate.getForObject(this.courseUrl, FullCourseOffering.class, params);
        return course;
    }

    @Override
    public CourseSection getCourseSectionOffering(String courseCode, String sectionCode, String termCode) {
        FullCourseOffering course = this.getCourseOffering(courseCode, termCode);
        if (course != null) {
            for (CourseSection section : course.getCourseSections()) {
                if (!section.getCode().equals(sectionCode)) continue;
                return section;
            }
        }
        return null;
    }
}

