/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.controller.BaseEmailController;
import org.jasig.portlet.emailpreview.util.MessageUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailMessageController
extends BaseEmailController {
    private static final String CONTENT_TYPE_TEXT_PREFIX = "text/plain;";
    protected final Log log = LogFactory.getLog(this.getClass());

    @ResourceMapping(value="emailMessage")
    public ModelAndView showMessage(ResourceRequest req, ResourceResponse res, @RequestParam(value="messageId") String messageId) {
        HashMap<String, EmailMessage> model = new HashMap<String, EmailMessage>();
        try {
            EmailMessage message = this.getEmailAccountService((PortletRequest)req).getMessage((PortletRequest)req, messageId);
            String contentType = message.getContentType();
            if (contentType != null && contentType.startsWith(CONTENT_TYPE_TEXT_PREFIX)) {
                String messageBody = message.getContent().getContentString();
                message.getContent().setContentString(MessageUtils.addClickableUrlsToMessageBody((String)messageBody));
            }
            model.put("message", message);
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered while attempting to retrieve message", (Throwable)ex);
        }
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="deleteMessages")
    public ModelAndView deleteMessages(ResourceRequest req, ResourceResponse res, @RequestParam(value="selectMessage", required=false) String[] uids) {
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            String deletePermitted = req.getPreferences().getValue("allowDelete", "true");
            if (!Boolean.valueOf(deletePermitted).booleanValue()) {
                String msg = "The delete function is not permitted for this portlet";
                throw new RuntimeException(msg);
            }
            if (uids != null && uids.length != 0) {
                this.getEmailAccountService((PortletRequest)req).deleteMessages((PortletRequest)req, uids);
            }
            model.put("success", "success");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete specified messages", e);
        }
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="toggleSeen")
    public ModelAndView toggleSeen(ResourceRequest req, ResourceResponse res, @RequestParam(value="selectMessage", required=false) String[] messageIds, @RequestParam(value="seenValue") boolean seenValue) {
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            if (messageIds != null && messageIds.length != 0) {
                this.getEmailAccountService((PortletRequest)req).setSeenFlag((PortletRequest)req, messageIds, seenValue);
            }
            model.put("success", "success");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update the seen flag for specified messageIds", e);
        }
        return new ModelAndView("json", model);
    }
}

