/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import org.jasig.portlet.emailpreview.controller.EmailSummaryController;
import org.springframework.stereotype.Service;

@Service
public class ViewSelectorDefault {
    private List<Pattern> mobileDeviceRegexes = null;

    @Resource(name="mobileDeviceRegexes")
    public void setMobileDeviceRegexes(List<String> patterns) {
        this.mobileDeviceRegexes = new ArrayList();
        for (String pattern : patterns) {
            this.mobileDeviceRegexes.add(Pattern.compile(pattern));
        }
    }

    public EmailSummaryController.View getEmailPreviewViewName(PortletRequest request) {
        String userAgent = request.getProperty("user-agent");
        EmailSummaryController.View showView = EmailSummaryController.View.PREVIEW;
        if (this.mobileDeviceRegexes != null && userAgent != null) {
            for (Pattern regex : this.mobileDeviceRegexes) {
                if (!regex.matcher(userAgent).matches()) continue;
                showView = EmailSummaryController.View.MOBILEPREVIEW;
            }
        }
        return showView;
    }

    public String getEventListViewName(PortletRequest request) {
        return "ajaxEventList";
    }
}

