/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.widget.service.AbstractCachingAlertService;
import org.jasig.portlet.widget.service.IAlert;
import org.jasig.portlet.widget.service.IAlertService;

public abstract class AbstractCachingAlertService
implements IAlertService {
    public static final String ENABLED_BY_DEFAULT_PREFERENCE = "AbstractCachingAlertService.enabledByDefault";
    public static final String MAX_ITEMS_PREFERENCE = "AbstractCachingAlertService.maxItems";
    private static final long MILLISECONDS_IN_TWO_MINUTES = 120000L;
    private static final Object LOCK = new Object();
    private Boolean enabled = null;
    private long cacheTimeout = 120000L;
    private volatile long whenGotten = 0L;
    private final List<IAlert> feed = new CopyOnWriteArrayList();
    private final Log log = LogFactory.getLog(this.getClass());

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(Boolean b) {
        this.enabled = b;
    }

    public final void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public final List<IAlert> fetch(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        boolean doFetch = this.enabled != null ? this.enabled : Boolean.valueOf(prefs.getValue(ENABLED_BY_DEFAULT_PREFERENCE, "true"));
        if (!doFetch) {
            return Collections.emptyList();
        }
        int maxItems = Integer.parseInt(prefs.getValue(MAX_ITEMS_PREFERENCE, "4"));
        if (this.isFeedExpired()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"About to start a thread to refreash the feed");
            }
            1 refreshThread = new /* Unavailable Anonymous Inner Class!! */;
            refreshThread.setDaemon(true);
            refreshThread.start();
        }
        return Collections.unmodifiableList(this.feed);
    }

    protected abstract List<IAlert> getFeedFromSource(PortletRequest var1);

    private boolean isFeedExpired() {
        long whenExpires = this.whenGotten + this.cacheTimeout;
        return System.currentTimeMillis() > whenExpires;
    }

    static /* synthetic */ Object access$000() {
        return LOCK;
    }

    static /* synthetic */ boolean access$100(AbstractCachingAlertService x0) {
        return x0.isFeedExpired();
    }

    static /* synthetic */ long access$202(AbstractCachingAlertService x0, long x1) {
        x0.whenGotten = x1;
        return x0.whenGotten;
    }

    static /* synthetic */ List access$300(AbstractCachingAlertService x0) {
        return x0.feed;
    }

    static /* synthetic */ Log access$400(AbstractCachingAlertService x0) {
        return x0.log;
    }
}

