/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.xml;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.jasig.portlet.widget.service.AbstractCachingAlertService;
import org.jasig.portlet.widget.service.BasicAlert;
import org.jasig.portlet.widget.service.IAlert;

public abstract class AbstractXmlAlertService
extends AbstractCachingAlertService {
    private static final String XPATH_ALERT = "//Alert";
    private static final String XPATH_ALERT_ENABLED_FLAG = ".//AlertFlag[text() = '1']";
    private static final String XPATH_HEAD = ".//AlertHead";
    private static final String XPATH_BODY = ".//AlertMsg/node()";
    private static final String XPATH_URL = ".//AlertLink/*";
    private final Log log = LogFactory.getLog(this.getClass());

    protected final List<IAlert> getFeedFromSource(PortletRequest req) {
        ArrayList<IAlert> rslt = new ArrayList<IAlert>();
        Document doc = this.loadDocument(req);
        if (this.log.isDebugEnabled()) {
            String xml = doc != null ? "\n" + doc.asXML() : "  [null]";
            this.log.debug((Object)("Received the following Alert XML:" + xml));
        }
        if (doc != null) {
            List nodes = doc.selectNodes(XPATH_ALERT);
            for (Node n : nodes) {
                if (n.selectSingleNode(XPATH_ALERT_ENABLED_FLAG) == null) continue;
                String head = n.valueOf(XPATH_HEAD);
                StringBuilder body = new StringBuilder();
                List bodyContent = n.selectNodes(XPATH_BODY);
                for (Node b : bodyContent) {
                    body.append(b.asXML());
                }
                String url = null;
                Node urlNode = n.selectSingleNode(XPATH_URL);
                if (urlNode != null && urlNode.asXML().trim().length() != 0) {
                    url = urlNode.asXML().trim();
                }
                BasicAlert alert = new BasicAlert(head, body.toString(), url);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding the following alert:  " + alert));
                }
                rslt.add((IAlert)alert);
            }
        }
        return rslt;
    }

    protected abstract Document loadDocument(PortletRequest var1);
}

