/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.xml;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import javax.portlet.PortletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jasig.portlet.widget.service.xml.AbstractXmlAlertService;

public final class HttpXmlAlertService
extends AbstractXmlAlertService {
    private static final String URL_PREFERENCE = "HttpXmlAlertService.feedUrl";
    private final Log log = LogFactory.getLog(this.getClass());

    protected Document loadDocument(PortletRequest req) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Updating feed from external source");
        }
        Document rslt = null;
        String url = req.getPreferences().getValue(URL_PREFERENCE, null);
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url.toString());
        Reader inpt = null;
        try {
            int statusCode = client.executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                String msg = "Method failed: " + get.getStatusLine();
                throw new RuntimeException(msg);
            }
            byte[] responseBody = get.getResponseBody();
            String xml = new String(responseBody).trim();
            inpt = new CharArrayReader(xml.toCharArray());
            rslt = new SAXReader().read(inpt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inpt != null) {
                try {
                    inpt.close();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
            get.releaseConnection();
        }
        return rslt;
    }
}

