/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.ValidatorException;
import org.jasig.portlet.widget.gadget.model.Module;
import org.jasig.portlet.widget.service.GoogleGadgetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class EditGoogleGadgetController {
    private GoogleGadgetService gadgetService;

    @Autowired(required=true)
    public void setGoogleGadgetService(GoogleGadgetService googleGadgetService) {
        this.gadgetService = googleGadgetService;
    }

    @RenderMapping
    public ModelAndView getSearchView(RenderRequest request) {
        List categories = this.gadgetService.getCategories();
        return new ModelAndView("searchGadgets", Collections.singletonMap("categories", categories));
    }

    @RenderMapping(params={"action=configure"})
    public ModelAndView getConfigurationView(@RequestParam(value="gadgetUrl") String gadgetUrl) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("gadgetUrl", gadgetUrl);
        Module module = this.gadgetService.getModule(gadgetUrl);
        model.put("module", (String)module);
        return new ModelAndView("configureGadget", model);
    }

    @ActionMapping(params={"action=saveConfiguration"})
    public void saveConfiguration(@RequestParam(value="gadgetUrl") String gadgetUrl, @RequestParam(value="width") int width, @RequestParam(value="height") int height, @RequestParam(value="title") String title, ActionRequest request, ActionResponse response) {
        PortletPreferences preferences = request.getPreferences();
        try {
            StringBuffer configuredUrl = new StringBuffer();
            configuredUrl.append("http://www.gmodules.com/ig/ifr?url=").append(URLEncoder.encode(gadgetUrl, "UTF-8"));
            configuredUrl.append("&amp;title=").append(URLEncoder.encode(title, "UTF-8"));
            configuredUrl.append("&amp;w=").append(width);
            configuredUrl.append("&amp;h=").append(height);
            configuredUrl.append("&amp;synd=open&amp;border=&amp;output=js");
            preferences.setValue("configuredUrl", configuredUrl.toString());
            preferences.store();
            response.setPortletMode(PortletMode.VIEW);
        }
        catch (ValidatorException e) {
        }
        catch (IOException e) {
        }
        catch (ReadOnlyException e) {
        }
        catch (PortletModeException e) {
            // empty catch block
        }
    }
}

