/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationError;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<NotificationCategory> categories;
    private List<NotificationError> errors;

    public NotificationResponse() {
        this.categories = new ArrayList<NotificationCategory>();
        this.errors = new ArrayList<NotificationError>();
    }

    public NotificationResponse(NotificationResponse response) {
        this(response.getCategories(), response.getErrors());
    }

    public NotificationResponse(List<NotificationCategory> categories, List<NotificationError> errors) {
        this.categories = new ArrayList<NotificationCategory>(categories);
        this.errors = new ArrayList<NotificationError>(errors);
    }

    public List<NotificationCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void setCategories(List<NotificationCategory> categories) {
        this.categories = new ArrayList<NotificationCategory>(categories);
    }

    public List<NotificationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void setErrors(List<NotificationError> errors) {
        this.errors = new ArrayList<NotificationError>(errors);
    }

    public NotificationResponse combine(NotificationResponse response) {
        NotificationResponse rslt = new NotificationResponse(this);
        rslt.addCategories(response.getCategories());
        rslt.addErrors(response.getErrors());
        return rslt;
    }

    public NotificationResponse filterErrors(Set<Integer> hiddenErrorKeys) {
        NotificationResponse rslt = new NotificationResponse(this);
        ArrayList<NotificationError> filteredErrors = new ArrayList<NotificationError>();
        for (NotificationError r : this.errors) {
            if (hiddenErrorKeys.contains(r.getKey())) continue;
            filteredErrors.add(r);
        }
        rslt.setErrors(filteredErrors);
        return rslt;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NotificationResponse [categories=");
        builder.append(this.categories);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }

    private void addCategories(List<NotificationCategory> newCategories) {
        for (NotificationCategory newCategory : newCategories) {
            boolean found = false;
            for (NotificationCategory myCategory : this.categories) {
                if (!myCategory.getTitle().toLowerCase().equals(newCategory.getTitle().toLowerCase())) continue;
                found = true;
                myCategory.addEntries(newCategory.getEntries());
            }
            if (found) continue;
            this.categories.add(newCategory);
        }
    }

    private void addErrors(List<NotificationError> newErrors) {
        for (NotificationError error : newErrors) {
            this.errors.add(error);
        }
    }
}

