/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jasig.portlet.notice.NotificationAttribute;

public class JsonAttributesDeserializer
extends JsonDeserializer<List<NotificationAttribute>> {
    public List<NotificationAttribute> deserialize(JsonParser parser, DeserializationContext ctx) throws JsonParseException, IOException {
        ArrayList<NotificationAttribute> result = new ArrayList<NotificationAttribute>();
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            NotificationAttribute[] attributes = (NotificationAttribute[])parser.readValueAs(NotificationAttribute[].class);
            result.addAll(Arrays.asList(attributes));
        } else if (token == JsonToken.START_OBJECT) {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                NotificationAttribute attr = new NotificationAttribute();
                attr.setName(parser.getCurrentName());
                parser.nextToken();
                String[] values = (String[])parser.readValueAs(String[].class);
                attr.setValues(Arrays.asList(values));
                result.add(attr);
            }
        } else {
            throw new IllegalArgumentException("Invalid attributes value. Expected array of NotificationAttribute objects or object with a series of string arrays. See https://issues.jasig.org/browse/NOTIFPLT-32 for format." + parser.getCurrentLocation().toString());
        }
        return result;
    }
}

