/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.service;

import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.cms.mvc.exception.StringCleaningException;
import org.jasig.portlet.cms.service.IStringCleaningService;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

@Component
public class AntiSamyStringCleaningService
implements IStringCleaningService,
InitializingBean {
    private Policy policy;
    private Policy textOnlyPolicy;
    private org.springframework.core.io.Resource resource;
    private org.springframework.core.io.Resource textOnlyResource;

    @Resource(name="policyFile")
    @Required
    public void setResource(org.springframework.core.io.Resource resource) {
        this.resource = resource;
    }

    @Resource(name="textOnlyPolicyFile")
    @Required
    public void setTextOnlyPolicy(org.springframework.core.io.Resource resource) {
        this.textOnlyResource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        InputStream policyStream = this.resource.getInputStream();
        try {
            this.policy = Policy.getInstance((InputStream)policyStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)policyStream);
        }
        InputStream textOnlyolicyStream = this.textOnlyResource.getInputStream();
        try {
            this.textOnlyPolicy = Policy.getInstance((InputStream)textOnlyolicyStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)textOnlyolicyStream);
        }
    }

    @Override
    public String getSafeContent(String content) {
        try {
            AntiSamy as = this.getAntiSamyInstance();
            CleanResults cr = as.scan(content, this.policy);
            return cr.getCleanHTML();
        }
        catch (ScanException e) {
            throw new StringCleaningException("Failed to scan new content", e);
        }
        catch (PolicyException e) {
            throw new StringCleaningException("Exception while cleaning content", e);
        }
    }

    @Override
    public String getTextContent(String content) {
        try {
            AntiSamy as = this.getAntiSamyInstance();
            CleanResults cr = as.scan(content, this.textOnlyPolicy);
            return cr.getCleanHTML();
        }
        catch (ScanException e) {
            throw new StringCleaningException("Failed to scan content for text summary", e);
        }
        catch (PolicyException e) {
            throw new StringCleaningException("Exception while getting text summary of content", e);
        }
    }

    protected AntiSamy getAntiSamyInstance() {
        return new AntiSamy();
    }
}

