/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.search.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.naming.directory.SearchControls;
import javax.portlet.PortletRequest;
import org.jasig.portlet.search.ldap.Person;
import org.jasig.portlet.search.ldap.PersonAttribute;
import org.jasig.portlet.search.ldap.PersonAttributesMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSearchServiceImpl {
    private String queryAttribute = "cn";
    private LdapTemplate ldapTemplate;
    private PersonAttributesMapper personAttributesMapper;
    private List<PersonAttribute> attributes;
    private Map<String, String> attributeTypeMap;
    private int returnedLimit = 10;
    private String searchBase = "";

    public List<Person> searchDirectory(String searchterm, PortletRequest request) {
        List allowedAttributes = this.getAllowedAttributes(request);
        allowedAttributes.add(this.personAttributesMapper.getFullNameAttribute());
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(this.returnedLimit);
        searchControls.setReturningAttributes(allowedAttributes.toArray(new String[0]));
        searchControls.setSearchScope(2);
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", "person"));
        filter.and((Filter)new WhitespaceWildcardsFilter(this.queryAttribute, searchterm));
        List people = this.ldapTemplate.search(this.searchBase, filter.encode(), searchControls, (AttributesMapper)this.personAttributesMapper);
        return people;
    }

    public Map<String, String> getAttributeTypeMap() {
        return this.attributeTypeMap;
    }

    protected List<String> getAllowedAttributes(PortletRequest request) {
        ArrayList<String> allowed = new ArrayList<String>();
        HashMap<String, Boolean> roles = new HashMap<String, Boolean>();
        block0: for (PersonAttribute attribute : this.attributes) {
            for (String role : attribute.getRoles()) {
                if (roles.containsKey(role)) {
                    if (((Boolean)roles.get(role)).booleanValue()) {
                        allowed.add(attribute.getKey());
                    }
                    allowed.add(attribute.getKey());
                    continue block0;
                }
                if (request.isUserInRole(role)) {
                    allowed.add(attribute.getKey());
                    roles.put(role, true);
                    continue block0;
                }
                roles.put(role, false);
            }
        }
        allowed.add(this.personAttributesMapper.getFullNameAttribute());
        return allowed;
    }

    @Required
    public void setQueryAttribute(String queryAttribute) {
        this.queryAttribute = queryAttribute;
    }

    @Autowired(required=true)
    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    @Autowired(required=true)
    public void setPersonAttributesMapper(PersonAttributesMapper personAttributesMapper) {
        this.personAttributesMapper = personAttributesMapper;
        if (!this.attributeTypeMap.containsKey(this.personAttributesMapper.getFullNameAttribute())) {
            this.attributeTypeMap.put(this.personAttributesMapper.getFullNameAttribute(), "none");
        }
    }

    @Required
    @Resource(name="directoryAttributes")
    public void setAttributes(List<PersonAttribute> attributes) {
        this.attributes = attributes;
        this.attributeTypeMap = new HashMap();
        for (PersonAttribute attr : attributes) {
            this.attributeTypeMap.put(attr.getKey(), attr.getDisplay());
        }
        if (this.personAttributesMapper != null && this.personAttributesMapper.getFullNameAttribute() != null) {
            this.attributeTypeMap.put(this.personAttributesMapper.getFullNameAttribute(), "none");
        }
    }

    public void setReturnedLimit(int returnedLimit) {
        this.returnedLimit = returnedLimit;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }
}

