<%--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

--%>
<jsp:directive.include file="/WEB-INF/jsp/include.jsp"/>
<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8" session="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<title>Yale Directory Search</title>
    <script src="http://www.google.com/uds/api?file=uds.js&amp;v=1.0&amp;key=${model.googleKey}" type="text/javascript"></script>
	<link type="text/css" href="http://www.google.com/uds/css/gsearch.css" rel="stylesheet"></link>
    
    <script type="text/javascript">
    //<![CDATA[

	var gWebSearch;
	var gBlogSearch;
	var gNewsSearch;
	var gBookSearch;
	var lastQuery;

    function LoadYaleGoogleSearchItems(searchtype, query) {

      gWebSearch = new GwebSearch();
	  gWebSearch.setSearchCompleteCallback(null, searchGoogleWeb);
      gNewsSearch = new GnewsSearch();
	  gNewsSearch.setSearchCompleteCallback(null, searchGoogleNews);
      gBlogSearch = new GblogSearch();
	  gBlogSearch.setSearchCompleteCallback(null, searchGoogleBlogs);
      gBookSearch = new GbookSearch();
	  gBookSearch.setSearchCompleteCallback(null, searchGoogleBooks);
	  searchGoogle(searchtype, query);
	  
    }

    GSearch.setOnLoadCallback(LoadYaleGoogleSearchItems('${param.searchtype}', '${param.query}'));
	
	function searchGoogleWeb() {
		displayGoogleResults(gWebSearch.results);
	}

	function searchGoogleNews() {
		displayGoogleResults(gNewsSearch.results);
	}

	function searchGoogleBlogs() {
		displayGoogleResults(gBlogSearch.results);
	}

	function searchGoogleBooks() {
		displayGoogleResults(gBookSearch.results);
	}

    function displayGoogleResults(results) {
    	var search = document.getElementById("googleResults");
    	search.innerHTML = "";
    	for (var i = 0; i < results.length; i++ ) {
    		var html = results[i].html;
    		var links = html.getElementsByTagName("a");
    		for (var j = 0; j < links.length; j++) {
    			if (links[j].className == 'gs-watermark')
    				links[j].parentNode.removeChild(links[j]);
    		}
    		search.appendChild(html);
    	}
    	var more = document.getElementById("moreGoogleLink");
    	more.style.display = "block";
    	more.href = "http://www.google.com/search?q=" + lastQuery;
		GSearch.getBranding(document.getElementById("googleBranding"));
    	window.parent.calcGoogleSearchHeight();
    }
    
    function searchGoogle(searchtype, query) {
    	lastQuery = query;
    	if (searchtype == 'googleWeb')
			gWebSearch.execute(query);
		else if (searchtype == 'googleNews')
			gNewsSearch.execute(query);
		else if (searchtype == 'googleBlogs')
			gBlogSearch.execute(query);
		else if (searchtype == 'googleBooks')
			gBookSearch.execute(query);
    	return false;
    }
        //]]>
    </script>
  </head>

<body>

    <style type="text/css">
    	.gs-result { margin-top: 10px; }
    </style>

	<div id="googleBranding" style="float: right"></div>
	<div id="googleResults" style="clear: right"></div>
	<div><a id="moreGoogleLink" href="" target=" " style="display:none; margin-top: 10px;">More results . . . </a></div>
    

</body>
</html>
    