/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr.util;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.resource.aggr.ResourcesDao;
import org.jasig.resource.aggr.om.BasicInclude;
import org.jasig.resource.aggr.om.Css;
import org.jasig.resource.aggr.om.Included;
import org.jasig.resource.aggr.om.Js;
import org.jasig.resource.aggr.om.Parameter;
import org.jasig.resource.aggr.om.Resources;
import org.jasig.resource.aggr.util.ResourcesElementsProvider;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourcesElementsProviderImpl
implements ResourceLoaderAware,
ResourcesElementsProvider {
    public static final String AGGREGATED_THEME_PARAMETER = ResourcesElementsProviderImpl.class.getPackage().getName() + ".aggregated_theme";
    public static final String DEFAULT_AGGREGATION_ENABLED = Boolean.TRUE.toString();
    private static final String OPEN_COND_COMMENT_PRE = "[";
    private static final String OPEN_COND_COMMENT_POST = "]> ";
    private static final String CLOSE_COND_COMMENT = " <![endif]";
    private static final String OPEN_SCRIPT = "<script type=\"text/javascript\" src=\"";
    private static final String CLOSE_SCRIPT = "\"></script>";
    private static final String OPEN_STYLE = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
    private static final String CLOSE_STYLE = "\"/>";
    private static final String SCRIPT = "script";
    private static final String LINK = "link";
    private static final String REL = "rel";
    private static final String SRC = "src";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String MEDIA = "media";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DocumentBuilder documentBuilder;
    private ResourceLoader resourceLoader;
    private ResourcesDao resourcesDao;

    public ResourcesElementsProviderImpl() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create DocumentBuilder", e);
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setResourcesDao(ResourcesDao resourcesDao) {
        this.resourcesDao = resourcesDao;
    }

    @Override
    public void setDefaultIncludedType(Included included) {
        switch (included) {
            case AGGREGATED: {
                System.setProperty(AGGREGATED_THEME_PARAMETER, Boolean.TRUE.toString());
                break;
            }
            case PLAIN: {
                System.setProperty(AGGREGATED_THEME_PARAMETER, Boolean.FALSE.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Included type: " + included);
            }
        }
    }

    @Override
    public Included getDefaultIncludedType() {
        if (Boolean.parseBoolean(System.getProperty(AGGREGATED_THEME_PARAMETER, DEFAULT_AGGREGATION_ENABLED))) {
            return Included.AGGREGATED;
        }
        return Included.PLAIN;
    }

    @Override
    public Included getIncludedType(HttpServletRequest request) {
        return this.getDefaultIncludedType();
    }

    @Override
    public String getResourcesParameter(HttpServletRequest request, String skinXml, String name) {
        Resources skinResources = this.getResources(request, skinXml);
        if (skinResources == null) {
            this.logger.warn((Object)("Could not find skin file " + skinXml));
            return null;
        }
        for (Parameter parameter : skinResources.getParameter()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public NodeList getResourcesXmlFragment(HttpServletRequest request, String skinXml) {
        Resources skinResources = this.getResources(request, skinXml);
        if (skinResources == null) {
            this.logger.warn((Object)("Could not find skin file " + skinXml));
            return null;
        }
        Document doc = this.documentBuilder.newDocument();
        DocumentFragment headFragment = doc.createDocumentFragment();
        String relativeRoot = request.getContextPath() + "/" + FilenameUtils.getPath((String)skinXml);
        for (Css css : skinResources.getCss()) {
            this.appendCssNode(doc, headFragment, css, relativeRoot);
        }
        for (Js js : skinResources.getJs()) {
            this.appendJsNode(doc, headFragment, js, relativeRoot);
        }
        return headFragment.getChildNodes();
    }

    protected Resources getResources(HttpServletRequest request, String skinXml) {
        File skinFile;
        Included includedType = this.getIncludedType(request);
        Resource skinResource = this.getResource(skinXml);
        try {
            skinFile = skinResource.getFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get File for skin XML path: " + skinXml, e);
        }
        switch (includedType) {
            case AGGREGATED: {
                String aggregatedSkinXml = this.resourcesDao.getAggregatedSkinName(skinFile.getName());
                File aggregatedSkinFile = new File(skinFile.getParentFile(), aggregatedSkinXml);
                if (aggregatedSkinFile.exists()) {
                    return this.resourcesDao.readResources(aggregatedSkinFile, includedType);
                }
                this.logger.warn((Object)("Could not find aggregated skin XML '" + aggregatedSkinFile + "' for '" + skinFile + "', falling back on unaggregated version."));
            }
            case PLAIN: 
            case BOTH: {
                return this.resourcesDao.readResources(skinFile, includedType);
            }
        }
        throw new UnsupportedOperationException("Unkown Included type: " + includedType);
    }

    protected Resource getResource(String skinXml) {
        if (!skinXml.startsWith("/")) {
            skinXml = "/" + skinXml;
        }
        return this.resourceLoader.getResource(skinXml);
    }

    protected void appendJsNode(Document document, DocumentFragment head, Js js, String relativeRoot) {
        String scriptPath = js.getValue();
        if (!this.resourcesDao.isAbsolute((BasicInclude)js)) {
            scriptPath = FilenameUtils.normalize((String)(relativeRoot + js.getValue()));
            scriptPath = FilenameUtils.separatorsToUnix((String)scriptPath);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("translated relative js value " + js.getValue() + " to " + scriptPath));
            }
        }
        if (this.resourcesDao.isConditional((BasicInclude)js)) {
            Comment c = document.createComment("");
            c.appendData(OPEN_COND_COMMENT_PRE);
            c.appendData(js.getConditional());
            c.appendData(OPEN_COND_COMMENT_POST);
            c.appendData(OPEN_SCRIPT);
            c.appendData(scriptPath);
            c.appendData(CLOSE_SCRIPT);
            c.appendData(CLOSE_COND_COMMENT);
            head.appendChild(c);
        } else {
            Element element = document.createElement(SCRIPT);
            element.setAttribute(TYPE, "text/javascript");
            element.setAttribute(SRC, scriptPath);
            element.appendChild(document.createTextNode(""));
            head.appendChild(element);
        }
    }

    protected void appendCssNode(Document document, DocumentFragment head, Css css, String relativeRoot) {
        String stylePath = css.getValue();
        if (!this.resourcesDao.isAbsolute((BasicInclude)css)) {
            stylePath = FilenameUtils.normalize((String)(relativeRoot + css.getValue()));
            stylePath = FilenameUtils.separatorsToUnix((String)stylePath);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("translated relative css value " + css.getValue() + " to " + stylePath));
            }
        }
        if (this.resourcesDao.isConditional((BasicInclude)css)) {
            Comment c = document.createComment("");
            c.appendData(OPEN_COND_COMMENT_PRE);
            c.appendData(css.getConditional());
            c.appendData(OPEN_COND_COMMENT_POST);
            c.appendData(OPEN_STYLE);
            c.appendData(stylePath);
            c.appendData("\" media=\"");
            c.appendData(css.getMedia());
            c.appendData(CLOSE_STYLE);
            c.appendData(CLOSE_COND_COMMENT);
            head.appendChild(c);
        } else {
            Element element = document.createElement(LINK);
            element.setAttribute(REL, "stylesheet");
            element.setAttribute(TYPE, "text/css");
            element.setAttribute(HREF, stylePath);
            element.setAttribute(MEDIA, css.getMedia());
            head.appendChild(element);
        }
    }
}

