/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.resource.aggr.CommonsLogErrorReporter;
import org.jasig.resource.aggr.MessageDigestOutputStream;
import org.jasig.resource.aggr.RelativePath;
import org.jasig.resource.aggr.ResourcesAggregator;
import org.jasig.resource.aggr.TrimmingWriter;
import org.jasig.resource.com.yahoo.platform.yui.compressor.CssCompressor;
import org.jasig.resource.com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import org.jasig.resource.org.mozilla.javascript.ErrorReporter;
import org.jasig.resource.org.mozilla.javascript.EvaluatorException;
import org.jasig.resourceserver.aggr.AggregationException;
import org.jasig.resourceserver.aggr.ResourcesDao;
import org.jasig.resourceserver.aggr.ResourcesDaoImpl;
import org.jasig.resourceserver.aggr.om.BasicInclude;
import org.jasig.resourceserver.aggr.om.Css;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.aggr.om.Js;
import org.jasig.resourceserver.aggr.om.Resources;

public class ResourcesAggregatorImpl
implements ResourcesAggregator {
    protected final Log logger;
    private static final String CSS = ".aggr.min.css";
    private static final String JS = ".aggr.min.js";
    private final ErrorReporter errorReporter;
    private final ResourcesDao resourcesDao;
    private final String encoding;
    private int cssLineBreakColumnNumber = 10000;
    private int jsLineBreakColumnNumber = 10000;
    private boolean obfuscateJs = true;
    private boolean displayJsWarnings = true;
    private boolean preserveAllSemiColons = true;
    private boolean disableJsOptimizations = false;
    private String digestAlgorithm = "MD5";

    public ResourcesAggregatorImpl(Log logger, String encoding) {
        this.logger = logger != null ? logger : LogFactory.getLog(this.getClass());
        this.encoding = encoding;
        this.resourcesDao = new ResourcesDaoImpl(this.logger, this.encoding);
        this.errorReporter = new CommonsLogErrorReporter(this.logger);
    }

    public ResourcesAggregatorImpl() {
        this(null, "UTF-8");
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public int getCssLineBreakColumnNumber() {
        return this.cssLineBreakColumnNumber;
    }

    public void setCssLineBreakColumnNumber(int cssLineBreakColumnNumber) {
        this.cssLineBreakColumnNumber = cssLineBreakColumnNumber;
    }

    public int getJsLineBreakColumnNumber() {
        return this.jsLineBreakColumnNumber;
    }

    public void setJsLineBreakColumnNumber(int jsLineBreakColumnNumber) {
        this.jsLineBreakColumnNumber = jsLineBreakColumnNumber;
    }

    public boolean isObfuscateJs() {
        return this.obfuscateJs;
    }

    public void setObfuscateJs(boolean obfuscateJs) {
        this.obfuscateJs = obfuscateJs;
    }

    public boolean isDisplayJsWarnings() {
        return this.displayJsWarnings;
    }

    public void setDisplayJsWarnings(boolean displayJsWarnings) {
        this.displayJsWarnings = displayJsWarnings;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isDisableJsOptimizations() {
        return this.disableJsOptimizations;
    }

    public void setDisableJsOptimizations(boolean disableJsOptimizations) {
        this.disableJsOptimizations = disableJsOptimizations;
    }

    @Override
    public void aggregate(File resourcesXml, File outputBaseDirectory) throws IOException, AggregationException {
        this.aggregate(resourcesXml, outputBaseDirectory, null);
    }

    @Override
    public void aggregate(File resourcesXml, File outputBaseDirectory, File sharedJavaScriptDirectory) throws IOException, AggregationException {
        MessageDigest digest;
        if (outputBaseDirectory != null) {
            outputBaseDirectory.mkdirs();
        }
        if (null == outputBaseDirectory || !outputBaseDirectory.isDirectory() || !outputBaseDirectory.canWrite()) {
            throw new IllegalArgumentException("outputBaseDirectory (" + (null == outputBaseDirectory ? null : outputBaseDirectory.getAbsolutePath()) + ") must be a directory AND writable");
        }
        try {
            digest = MessageDigest.getInstance(this.digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Failed to create MessageDigest for algorithm '" + this.digestAlgorithm, e);
        }
        Resources original = this.resourcesDao.readResources(resourcesXml, Included.AGGREGATED);
        File resourcesParentDir = resourcesXml.getParentFile();
        CssCallback cssCallback = new CssCallback(digest, resourcesParentDir, outputBaseDirectory);
        List<Css> cssResult = this.aggregateBasicIncludes(original.getCss(), cssCallback);
        JsCallback jsCallback = new JsCallback(digest, resourcesParentDir, outputBaseDirectory, sharedJavaScriptDirectory);
        List<Js> jsResult = this.aggregateBasicIncludes(original.getJs(), jsCallback);
        Resources aggregatedForm = new Resources();
        aggregatedForm.getCss().addAll(cssResult);
        aggregatedForm.getJs().addAll(jsResult);
        aggregatedForm.getParameter().addAll(original.getParameter());
        String aggregatedFormOutputFileName = this.resourcesDao.getAggregatedSkinName(resourcesXml.getName());
        File aggregatedOutputFile = new File(outputBaseDirectory, aggregatedFormOutputFileName);
        this.resourcesDao.writeResources(aggregatedForm, aggregatedOutputFile);
        this.logger.info((Object)("Aggregated " + original.getJs().size() + " JavaScript files down to " + aggregatedForm.getJs().size() + " and " + original.getCss().size() + " CSS files down to " + aggregatedForm.getCss().size() + " for: " + resourcesXml));
    }

    protected <T extends BasicInclude> List<T> aggregateBasicIncludes(List<T> original, AggregatorCallback<T> callback) throws IOException {
        LinkedList<T> result = new LinkedList<T>();
        LinkedList<BasicInclude> currentAggregateList = new LinkedList<BasicInclude>();
        for (BasicInclude originalElement : original) {
            if (currentAggregateList.isEmpty()) {
                currentAggregateList.add(originalElement);
                continue;
            }
            BasicInclude baseElement = (BasicInclude)currentAggregateList.getFirst();
            if (callback.willAggregate(originalElement, baseElement)) {
                currentAggregateList.add(originalElement);
                continue;
            }
            T aggregate = callback.aggregate(currentAggregateList);
            if (null != aggregate) {
                result.add(aggregate);
            } else {
                this.logger.warn((Object)("Generated 0 byte aggregate from: " + this.generatePathList(currentAggregateList)));
            }
            currentAggregateList.clear();
            currentAggregateList.add(originalElement);
        }
        if (currentAggregateList.size() > 0) {
            T aggregate = callback.aggregate(currentAggregateList);
            if (null != aggregate) {
                result.add(aggregate);
            } else {
                this.logger.warn((Object)("Generated 0 byte aggregate from: " + this.generatePathList(currentAggregateList)));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends BasicInclude> T aggregateList(MessageDigest digest, Deque<T> elements, File skinDirectory, File outputRoot, File alternateOutput, String extension, AggregatorCallback<T> callback) throws IOException {
        File aggregateOutputFile;
        if (null == elements || elements.size() == 0) {
            return null;
        }
        BasicInclude headElement = (BasicInclude)elements.getFirst();
        if (elements.size() == 1 && this.resourcesDao.isAbsolute(headElement)) {
            return (T)headElement;
        }
        File tempFile = File.createTempFile("working.", extension);
        try {
            BufferedOutputStream bufferedFileStream;
            digest.reset();
            TrimmingWriter trimmingWriter = null;
            try {
                bufferedFileStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                MessageDigestOutputStream digestStream = new MessageDigestOutputStream(bufferedFileStream, digest);
                OutputStreamWriter aggregateWriter = new OutputStreamWriter((OutputStream)digestStream, this.encoding);
                trimmingWriter = new TrimmingWriter(aggregateWriter);
                for (BasicInclude element : elements) {
                    FileInputStream fis;
                    block18: {
                        File resourceFile = new File(skinDirectory, element.getValue());
                        fis = null;
                        try {
                            fis = new FileInputStream(resourceFile);
                            BOMInputStream bomIs = new BOMInputStream((InputStream)new BufferedInputStream(fis));
                            if (bomIs.hasBOM()) {
                                this.logger.debug((Object)("Stripping UTF-8 BOM from: " + resourceFile));
                            }
                            InputStreamReader resourceIn = new InputStreamReader((InputStream)bomIs, this.encoding);
                            if (element.isCompressed()) {
                                IOUtils.copy((Reader)resourceIn, (Writer)trimmingWriter);
                                break block18;
                            }
                            callback.compress(resourceIn, trimmingWriter);
                        }
                        catch (IOException e) {
                            try {
                                throw new IOException("Failed to read '" + resourceFile + "' for skin: " + skinDirectory, e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fis);
                                throw throwable;
                            }
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    trimmingWriter.write(SystemUtils.LINE_SEPARATOR);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(trimmingWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)trimmingWriter);
            if (trimmingWriter.getCharCount() == 0) {
                bufferedFileStream = null;
                return (T)bufferedFileStream;
            }
            String checksum = Base64.encodeBase64URLSafeString((byte[])digest.digest());
            digest.reset();
            String newFileName = checksum + extension;
            if (alternateOutput == null) {
                String elementRelativePath = FilenameUtils.getFullPath((String)headElement.getValue());
                File directoryInOutputRoot = new File(outputRoot, elementRelativePath);
                directoryInOutputRoot.mkdirs();
                aggregateOutputFile = new File(directoryInOutputRoot, newFileName);
            } else {
                aggregateOutputFile = new File(alternateOutput, newFileName);
            }
            FileUtils.deleteQuietly((File)aggregateOutputFile);
            FileUtils.moveFile((File)tempFile, (File)aggregateOutputFile);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
        String newResultValue = RelativePath.getRelativePath(outputRoot, aggregateOutputFile);
        this.logAggregation(elements, newResultValue);
        return callback.getAggregateElement(newResultValue, elements);
    }

    protected void logAggregation(Deque<? extends BasicInclude> elements, String fileName) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Aggregated ").append(fileName).append(" from ").append(this.generatePathList(elements));
            this.logger.debug((Object)msg);
        }
    }

    protected String generatePathList(Collection<? extends BasicInclude> elements) {
        StringBuilder msg = new StringBuilder();
        msg.append("[");
        Iterator<? extends BasicInclude> elementItr = elements.iterator();
        while (elementItr.hasNext()) {
            msg.append(elementItr.next().getValue());
            if (!elementItr.hasNext()) continue;
            msg.append(", ");
        }
        msg.append("]");
        return msg.toString();
    }

    protected boolean willAggregateWith(Css first, Css second) {
        Validate.notNull((Object)first, (String)"Css argument cannot be null");
        Validate.notNull((Object)second, (String)"Css argument cannot be null");
        if (this.resourcesDao.isAbsolute((BasicInclude)first) || this.resourcesDao.isAbsolute((BasicInclude)second)) {
            return false;
        }
        String firstFullPath = FilenameUtils.getFullPath((String)first.getValue());
        String secondFullPath = FilenameUtils.getFullPath((String)second.getValue());
        return new EqualsBuilder().append((Object)first.getConditional(), (Object)second.getConditional()).append((Object)first.getMedia(), (Object)second.getMedia()).append((Object)firstFullPath, (Object)secondFullPath).isEquals();
    }

    protected boolean willAggregateWith(Js first, Js second) {
        Validate.notNull((Object)first, (String)"Js cannot be null");
        Validate.notNull((Object)second, (String)"Js cannot be null");
        if (this.resourcesDao.isAbsolute((BasicInclude)first) || this.resourcesDao.isAbsolute((BasicInclude)second)) {
            return false;
        }
        return new EqualsBuilder().append((Object)first.getConditional(), (Object)second.getConditional()).isEquals();
    }

    private class CssCallback
    implements AggregatorCallback<Css> {
        private final MessageDigest digest;
        private final File resourcesParentDir;
        private final File outputBaseDirectory;

        public CssCallback(MessageDigest digest, File resourcesParentDir, File outputBaseDirectory) {
            this.digest = digest;
            this.resourcesParentDir = resourcesParentDir;
            this.outputBaseDirectory = outputBaseDirectory;
        }

        @Override
        public void compress(Reader reader, Writer writer) throws EvaluatorException, IOException {
            CssCompressor jsCompressor = new CssCompressor(reader);
            jsCompressor.compress(writer, ResourcesAggregatorImpl.this.cssLineBreakColumnNumber);
        }

        @Override
        public Css getAggregateElement(String location, Deque<Css> elements) {
            Css baseElement = elements.getFirst();
            Css aggregate = new Css();
            aggregate.setValue(location);
            aggregate.setConditional(baseElement.getConditional());
            aggregate.setMedia(baseElement.getMedia());
            aggregate.setCompressed(Boolean.valueOf(true));
            return aggregate;
        }

        @Override
        public Css aggregate(Deque<Css> list) throws IOException {
            return ResourcesAggregatorImpl.this.aggregateList(this.digest, list, this.resourcesParentDir, this.outputBaseDirectory, null, ResourcesAggregatorImpl.CSS, this);
        }

        @Override
        public boolean willAggregate(Css first, Css second) {
            return ResourcesAggregatorImpl.this.willAggregateWith(first, second);
        }
    }

    private class JsCallback
    implements AggregatorCallback<Js> {
        private final MessageDigest digest;
        private final File resourcesParentDir;
        private final File outputBaseDirectory;
        private final File sharedJavaScriptDirectory;

        public JsCallback(MessageDigest digest, File resourcesParentDir, File outputBaseDirectory, File sharedJavaScriptDirectory) {
            this.digest = digest;
            this.resourcesParentDir = resourcesParentDir;
            this.outputBaseDirectory = outputBaseDirectory;
            this.sharedJavaScriptDirectory = sharedJavaScriptDirectory;
        }

        @Override
        public void compress(Reader reader, Writer writer) throws EvaluatorException, IOException {
            JavaScriptCompressor jsCompressor = new JavaScriptCompressor(reader, ResourcesAggregatorImpl.this.errorReporter);
            jsCompressor.compress(writer, ResourcesAggregatorImpl.this.jsLineBreakColumnNumber, ResourcesAggregatorImpl.this.obfuscateJs, ResourcesAggregatorImpl.this.displayJsWarnings, ResourcesAggregatorImpl.this.preserveAllSemiColons, ResourcesAggregatorImpl.this.disableJsOptimizations);
        }

        @Override
        public Js getAggregateElement(String location, Deque<Js> elements) {
            Js baseElement = elements.getFirst();
            Js aggregate = new Js();
            aggregate.setValue(location);
            aggregate.setConditional(baseElement.getConditional());
            aggregate.setCompressed(Boolean.valueOf(true));
            return aggregate;
        }

        @Override
        public Js aggregate(Deque<Js> list) throws IOException {
            File alternateOutput = this.sharedJavaScriptDirectory == null ? this.outputBaseDirectory : this.sharedJavaScriptDirectory;
            return ResourcesAggregatorImpl.this.aggregateList(this.digest, list, this.resourcesParentDir, this.outputBaseDirectory, alternateOutput, ResourcesAggregatorImpl.JS, this);
        }

        @Override
        public boolean willAggregate(Js first, Js second) {
            return ResourcesAggregatorImpl.this.willAggregateWith(first, second);
        }
    }

    public static interface AggregatorCallback<T extends BasicInclude> {
        public void compress(Reader var1, Writer var2) throws EvaluatorException, IOException;

        public T getAggregateElement(String var1, Deque<T> var2);

        public T aggregate(Deque<T> var1) throws IOException;

        public boolean willAggregate(T var1, T var2);
    }
}

