/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.org.mozilla.javascript;

import org.jasig.resource.org.mozilla.javascript.Callable;
import org.jasig.resource.org.mozilla.javascript.Context;
import org.jasig.resource.org.mozilla.javascript.Function;
import org.jasig.resource.org.mozilla.javascript.IdFunctionObject;
import org.jasig.resource.org.mozilla.javascript.IdScriptableObject;
import org.jasig.resource.org.mozilla.javascript.Kit;
import org.jasig.resource.org.mozilla.javascript.NativeString;
import org.jasig.resource.org.mozilla.javascript.ObjToIntMap;
import org.jasig.resource.org.mozilla.javascript.ScriptRuntime;
import org.jasig.resource.org.mozilla.javascript.Scriptable;
import org.jasig.resource.org.mozilla.javascript.ScriptableObject;
import org.jasig.resource.org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptableObject {
    static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = new Object();
    private static final Integer NEGATIVE_ONE = new Integer(-1);
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int MAX_PROTOTYPE_ID = 21;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;

    static void init(Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray();
        obj.exportAsJSClass(21, scope, sealed);
    }

    private NativeArray() {
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long length) {
        int intLength = (int)length;
        if ((long)intLength == length && intLength > 0) {
            if (intLength > 10000) {
                intLength = 10000;
            }
            this.dense = new Object[intLength];
            for (int i = 0; i < intLength; ++i) {
                this.dense[i] = NOT_FOUND;
            }
        }
        this.length = length;
    }

    public NativeArray(Object[] array) {
        this.dense = array;
        this.length = array.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getMaxInstanceId() {
        return 1;
    }

    protected int findInstanceIdInfo(String s) {
        if (s.equals("length")) {
            return NativeArray.instanceIdInfo(6, 1);
        }
        return super.findInstanceIdInfo(s);
    }

    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(id);
    }

    protected void setInstanceIdValue(int id, Object value) {
        if (id == 1) {
            this.setLength(value);
            return;
        }
        super.setInstanceIdValue(id, value);
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 1;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 5: {
                arity = 1;
                s = "join";
                break;
            }
            case 6: {
                arity = 0;
                s = "reverse";
                break;
            }
            case 7: {
                arity = 1;
                s = "sort";
                break;
            }
            case 8: {
                arity = 1;
                s = "push";
                break;
            }
            case 9: {
                arity = 1;
                s = "pop";
                break;
            }
            case 10: {
                arity = 1;
                s = "shift";
                break;
            }
            case 11: {
                arity = 1;
                s = "unshift";
                break;
            }
            case 12: {
                arity = 1;
                s = "splice";
                break;
            }
            case 13: {
                arity = 1;
                s = "concat";
                break;
            }
            case 14: {
                arity = 1;
                s = "slice";
                break;
            }
            case 15: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 16: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 17: {
                arity = 1;
                s = "every";
                break;
            }
            case 18: {
                arity = 1;
                s = "filter";
                break;
            }
            case 19: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 20: {
                arity = 1;
                s = "map";
                break;
            }
            case 21: {
                arity = 1;
                s = "some";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, id, s, arity);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ARRAY_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                boolean inNewExpr;
                boolean bl = inNewExpr = thisObj == null;
                if (!inNewExpr) {
                    return f.construct(cx, scope, args);
                }
                return NativeArray.jsConstructor(cx, scope, args);
            }
            case 2: {
                return NativeArray.toStringHelper(cx, scope, thisObj, cx.hasFeature(4), false);
            }
            case 3: {
                return NativeArray.toStringHelper(cx, scope, thisObj, false, true);
            }
            case 4: {
                return NativeArray.toStringHelper(cx, scope, thisObj, true, false);
            }
            case 5: {
                return NativeArray.js_join(cx, thisObj, args);
            }
            case 6: {
                return NativeArray.js_reverse(cx, thisObj, args);
            }
            case 7: {
                return NativeArray.js_sort(cx, scope, thisObj, args);
            }
            case 8: {
                return NativeArray.js_push(cx, thisObj, args);
            }
            case 9: {
                return NativeArray.js_pop(cx, thisObj, args);
            }
            case 10: {
                return NativeArray.js_shift(cx, thisObj, args);
            }
            case 11: {
                return NativeArray.js_unshift(cx, thisObj, args);
            }
            case 12: {
                return NativeArray.js_splice(cx, scope, thisObj, args);
            }
            case 13: {
                return NativeArray.js_concat(cx, scope, thisObj, args);
            }
            case 14: {
                return this.js_slice(cx, thisObj, args);
            }
            case 15: {
                return this.indexOfHelper(cx, thisObj, args, false);
            }
            case 16: {
                return this.indexOfHelper(cx, thisObj, args, true);
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return this.iterativeMethod(cx, id, scope, thisObj, args);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public Object get(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start);
    }

    public boolean has(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index] != NOT_FOUND;
        }
        return super.has(index, start);
    }

    private static long toArrayIndex(String id) {
        long index;
        double d = ScriptRuntime.toNumber(id);
        if (d == d && (double)(index = ScriptRuntime.toUint32(d)) == d && index != 0xFFFFFFFFL && Long.toString(index).equals(id)) {
            return index;
        }
        return -1L;
    }

    public void put(String id, Scriptable start, Object value) {
        long index;
        super.put(id, start, value);
        if (start == this && (index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
        }
    }

    public void put(int index, Scriptable start, Object value) {
        if (start == this && !this.isSealed() && this.dense != null && 0 <= index && index < this.dense.length) {
            this.dense[index] = value;
        } else {
            super.put(index, start, value);
        }
        if (start == this && this.length <= (long)index) {
            this.length = (long)index + 1L;
        }
    }

    public void delete(int index) {
        if (!this.isSealed() && this.dense != null && 0 <= index && index < this.dense.length) {
            this.dense[index] = NOT_FOUND;
        } else {
            super.delete(index);
        }
    }

    public Object[] getIds() {
        Object[] superIds = super.getIds();
        if (this.dense == null) {
            return superIds;
        }
        int N = this.dense.length;
        long currentLength = this.length;
        if ((long)N > currentLength) {
            N = (int)currentLength;
        }
        if (N == 0) {
            return superIds;
        }
        int superLength = superIds.length;
        Object[] ids = new Object[N + superLength];
        System.arraycopy(this.dense, 0, ids, 0, N);
        int presentCount = 0;
        for (int i = 0; i != N; ++i) {
            if (ids[i] == NOT_FOUND) continue;
            ids[presentCount] = new Integer(i);
            ++presentCount;
        }
        if (presentCount != N) {
            Object[] tmp = new Object[presentCount + superLength];
            System.arraycopy(ids, 0, tmp, 0, presentCount);
            ids = tmp;
        }
        System.arraycopy(superIds, 0, ids, presentCount, superLength);
        return ids;
    }

    public Object getDefaultValue(Class hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(hint);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        if (args.length == 0) {
            return new NativeArray();
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args);
        }
        Object arg0 = args[0];
        if (args.length > 1 || !(arg0 instanceof Number)) {
            return new NativeArray(args);
        }
        long len = ScriptRuntime.toUint32(arg0);
        if ((double)len != ((Number)arg0).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(len);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    private void setLength(Object val) {
        double d = ScriptRuntime.toNumber(val);
        long longVal = ScriptRuntime.toUint32(d);
        if ((double)longVal != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (longVal < this.length) {
            if (this.length - longVal > 4096L) {
                Object[] e = this.getIds();
                for (int i = 0; i < e.length; ++i) {
                    Object id = e[i];
                    if (id instanceof String) {
                        String strId = (String)id;
                        long index = NativeArray.toArrayIndex(strId);
                        if (index < longVal) continue;
                        this.delete(strId);
                        continue;
                    }
                    int index = (Integer)id;
                    if ((long)index < longVal) continue;
                    this.delete(index);
                }
            } else {
                for (long i = longVal; i < this.length; ++i) {
                    NativeArray.deleteElem(this, i);
                }
            }
        }
        this.length = longVal;
    }

    static long getLengthProperty(Context cx, Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).getLength();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).getLength();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getObjectProp(obj, "length", cx));
    }

    private static Object setLengthProperty(Context cx, Scriptable target, long length) {
        return ScriptRuntime.setObjectProp(target, "length", (Object)ScriptRuntime.wrapNumber(length), cx);
    }

    private static void deleteElem(Scriptable target, long index) {
        int i = (int)index;
        if ((long)i == index) {
            target.delete(i);
        } else {
            target.delete(Long.toString(index));
        }
    }

    private static Object getElem(Context cx, Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            return ScriptRuntime.getObjectProp(target, id, cx);
        }
        return ScriptRuntime.getObjectIndex(target, (int)index, cx);
    }

    private static void setElem(Context cx, Scriptable target, long index, Object value) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptRuntime.setObjectProp(target, id, value, cx);
        } else {
            ScriptRuntime.setObjectIndex(target, (int)index, value, cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context cx, Scriptable scope, Scriptable thisObj, boolean toSource, boolean toLocale) {
        boolean iterating;
        boolean toplevel;
        String separator;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        StringBuffer result = new StringBuffer(256);
        if (toSource) {
            result.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i = 0L;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                for (i = 0L; i < length; ++i) {
                    Object elem;
                    if (i > 0L) {
                        result.append(separator);
                    }
                    if ((elem = NativeArray.getElem(cx, thisObj, i)) == null || elem == Undefined.instance) {
                        haslast = false;
                        continue;
                    }
                    haslast = true;
                    if (toSource) {
                        result.append(ScriptRuntime.uneval(cx, scope, elem));
                        continue;
                    }
                    if (elem instanceof String) {
                        String s = (String)elem;
                        if (toSource) {
                            result.append('\"');
                            result.append(ScriptRuntime.escapeString(s));
                            result.append('\"');
                            continue;
                        }
                        result.append(s);
                        continue;
                    }
                    if (toLocale) {
                        Callable fun = ScriptRuntime.getPropFunctionAndThis(elem, "toLocaleString", cx);
                        Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
                        elem = fun.call(cx, scope, funThis, ScriptRuntime.emptyArgs);
                    }
                    result.append(ScriptRuntime.toString(elem));
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        if (toSource) {
            if (!haslast && i > 0L) {
                result.append(", ]");
            } else {
                result.append(']');
            }
        }
        return result.toString();
    }

    private static String js_join(Context cx, Scriptable thisObj, Object[] args) {
        String str;
        int length;
        long llength = NativeArray.getLengthProperty(cx, thisObj);
        if (llength != (long)(length = (int)llength)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(llength));
        }
        String separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (length == 0) {
            return "";
        }
        String[] buf = new String[length];
        int total_size = 0;
        for (int i = 0; i != length; ++i) {
            Object temp = NativeArray.getElem(cx, thisObj, i);
            if (temp == null || temp == Undefined.instance) continue;
            str = ScriptRuntime.toString(temp);
            total_size += str.length();
            buf[i] = str;
        }
        StringBuffer sb = new StringBuffer(total_size += (length - 1) * separator.length());
        for (int i = 0; i != length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            if ((str = buf[i]) == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static Scriptable js_reverse(Context cx, Scriptable thisObj, Object[] args) {
        long len = NativeArray.getLengthProperty(cx, thisObj);
        long half = len / 2L;
        for (long i = 0L; i < half; ++i) {
            long j = len - i - 1L;
            Object temp1 = NativeArray.getElem(cx, thisObj, i);
            Object temp2 = NativeArray.getElem(cx, thisObj, j);
            NativeArray.setElem(cx, thisObj, i, temp2);
            NativeArray.setElem(cx, thisObj, j, temp1);
        }
        return thisObj;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] cmpBuf;
        Object compare;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (length <= 1L) {
            return thisObj;
        }
        if (args.length > 0 && Undefined.instance != args[0]) {
            compare = args[0];
            cmpBuf = new Object[2];
        } else {
            compare = null;
            cmpBuf = null;
        }
        if (length >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(cx, scope, thisObj, length, compare, cmpBuf);
        } else {
            int i;
            int ilength = (int)length;
            Object[] working = new Object[ilength];
            for (i = 0; i != ilength; ++i) {
                working[i] = NativeArray.getElem(cx, thisObj, i);
            }
            NativeArray.heapsort(cx, scope, working, ilength, compare, cmpBuf);
            for (i = 0; i != ilength; ++i) {
                NativeArray.setElem(cx, thisObj, i, working[i]);
            }
        }
        return thisObj;
    }

    private static boolean isBigger(Context cx, Scriptable scope, Object x, Object y, Object cmp, Object[] cmpBuf) {
        Scriptable funThis;
        Object undef;
        if (cmp == null) {
            if (cmpBuf != null) {
                Kit.codeBug();
            }
        } else if (cmpBuf == null || cmpBuf.length != 2) {
            Kit.codeBug();
        }
        if ((undef = Undefined.instance) == y) {
            return false;
        }
        if (undef == x) {
            return true;
        }
        if (cmp == null) {
            String b;
            String a = ScriptRuntime.toString(x);
            return a.compareTo(b = ScriptRuntime.toString(y)) > 0;
        }
        cmpBuf[0] = x;
        cmpBuf[1] = y;
        Callable fun = ScriptRuntime.getValueFunctionAndThis(cmp, cx);
        Object ret = fun.call(cx, scope, funThis = ScriptRuntime.lastStoredScriptable(cx), cmpBuf);
        double d = ScriptRuntime.toNumber(ret);
        return d > 0.0;
    }

    private static void heapsort(Context cx, Scriptable scope, Object[] array, int length, Object cmp, Object[] cmpBuf) {
        Object pivot;
        if (length <= 1) {
            Kit.codeBug();
        }
        int i = length / 2;
        while (i != 0) {
            pivot = array[--i];
            NativeArray.heapify(cx, scope, pivot, array, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1) {
            pivot = array[--i];
            array[i] = array[0];
            NativeArray.heapify(cx, scope, pivot, array, 0, i, cmp, cmpBuf);
        }
    }

    private static void heapify(Context cx, Scriptable scope, Object pivot, Object[] array, int i, int end, Object cmp, Object[] cmpBuf) {
        int child;
        while ((child = i * 2 + 1) < end) {
            Object nextVal;
            Object childVal = array[child];
            if (child + 1 < end && NativeArray.isBigger(cx, scope, nextVal = array[child + 1], childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            array[i] = childVal;
            i = child;
        }
        array[i] = pivot;
    }

    private static void heapsort_extended(Context cx, Scriptable scope, Scriptable target, long length, Object cmp, Object[] cmpBuf) {
        Object pivot;
        if (length <= 1L) {
            Kit.codeBug();
        }
        long i = length / 2L;
        while (i != 0L) {
            pivot = NativeArray.getElem(cx, target, --i);
            NativeArray.heapify_extended(cx, scope, pivot, target, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1L) {
            pivot = NativeArray.getElem(cx, target, --i);
            NativeArray.setElem(cx, target, i, NativeArray.getElem(cx, target, 0L));
            NativeArray.heapify_extended(cx, scope, pivot, target, 0L, i, cmp, cmpBuf);
        }
    }

    private static void heapify_extended(Context cx, Scriptable scope, Object pivot, Scriptable target, long i, long end, Object cmp, Object[] cmpBuf) {
        long child;
        while ((child = i * 2L + 1L) < end) {
            Object nextVal;
            Object childVal = NativeArray.getElem(cx, target, child);
            if (child + 1L < end && NativeArray.isBigger(cx, scope, nextVal = NativeArray.getElem(cx, target, child + 1L), childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            NativeArray.setElem(cx, target, i, childVal);
            i = child;
        }
        NativeArray.setElem(cx, target, i, pivot);
    }

    private static Object js_push(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(cx, thisObj);
        for (int i = 0; i < args.length; ++i) {
            NativeArray.setElem(cx, thisObj, length + (long)i, args[i]);
        }
        Object lengthObj = NativeArray.setLengthProperty(cx, thisObj, length += (long)args.length);
        if (cx.getLanguageVersion() == 120) {
            return args.length == 0 ? Undefined.instance : args[args.length - 1];
        }
        return lengthObj;
    }

    private static Object js_pop(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(cx, thisObj);
        Object result = length > 0L ? NativeArray.getElem(cx, thisObj, --length) : Undefined.instance;
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result;
    }

    private static Object js_shift(Context cx, Scriptable thisObj, Object[] args) {
        Object result;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (length > 0L) {
            long i = 0L;
            result = NativeArray.getElem(cx, thisObj, i);
            if (--length > 0L) {
                for (i = 1L; i <= length; ++i) {
                    Object temp = NativeArray.getElem(cx, thisObj, i);
                    NativeArray.setElem(cx, thisObj, i - 1L, temp);
                }
            }
        } else {
            result = Undefined.instance;
        }
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result;
    }

    private static Object js_unshift(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(cx, thisObj);
        int argc = args.length;
        if (args.length > 0) {
            if (length > 0L) {
                for (long last = length - 1L; last >= 0L; --last) {
                    Object temp = NativeArray.getElem(cx, thisObj, last);
                    NativeArray.setElem(cx, thisObj, last + (long)argc, temp);
                }
            }
            for (int i = 0; i < args.length; ++i) {
                NativeArray.setElem(cx, thisObj, i, args[i]);
            }
            return NativeArray.setLengthProperty(cx, thisObj, length += (long)args.length);
        }
        return ScriptRuntime.wrapNumber(length);
    }

    private static Object js_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object temp;
        long last;
        long count;
        scope = NativeArray.getTopLevelScope(scope);
        Object result = ScriptRuntime.newObject(cx, scope, "Array", null);
        int argc = args.length;
        if (argc == 0) {
            return result;
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        long begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
        --argc;
        if (args.length == 1) {
            count = length - begin;
        } else {
            double dcount = ScriptRuntime.toInteger(args[1]);
            count = dcount < 0.0 ? 0L : (dcount > (double)(length - begin) ? length - begin : (long)dcount);
            --argc;
        }
        long end = begin + count;
        if (count != 0L) {
            if (count == 1L && cx.getLanguageVersion() == 120) {
                result = NativeArray.getElem(cx, thisObj, begin);
            } else {
                for (long last2 = begin; last2 != end; ++last2) {
                    Scriptable resultArray = (Scriptable)result;
                    Object temp2 = NativeArray.getElem(cx, thisObj, last2);
                    NativeArray.setElem(cx, resultArray, last2 - begin, temp2);
                }
            }
        } else if (count == 0L && cx.getLanguageVersion() == 120) {
            result = Undefined.instance;
        }
        long delta = (long)argc - count;
        if (delta > 0L) {
            for (last = length - 1L; last >= end; --last) {
                temp = NativeArray.getElem(cx, thisObj, last);
                NativeArray.setElem(cx, thisObj, last + delta, temp);
            }
        } else if (delta < 0L) {
            for (last = end; last < length; ++last) {
                temp = NativeArray.getElem(cx, thisObj, last);
                NativeArray.setElem(cx, thisObj, last + delta, temp);
            }
        }
        int argoffset = args.length - argc;
        for (int i = 0; i < argc; ++i) {
            NativeArray.setElem(cx, thisObj, begin + (long)i, args[i + argoffset]);
        }
        NativeArray.setLengthProperty(cx, thisObj, length + delta);
        return result;
    }

    private static Scriptable js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long length;
        scope = NativeArray.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, "Array");
        Scriptable result = ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        long slot = 0L;
        if (ScriptRuntime.instanceOf(thisObj, ctor, cx)) {
            length = NativeArray.getLengthProperty(cx, thisObj);
            for (slot = 0L; slot < length; ++slot) {
                Object temp = NativeArray.getElem(cx, thisObj, slot);
                NativeArray.setElem(cx, result, slot, temp);
            }
        } else {
            NativeArray.setElem(cx, result, slot++, thisObj);
        }
        for (int i = 0; i < args.length; ++i) {
            if (ScriptRuntime.instanceOf(args[i], ctor, cx)) {
                Scriptable arg = (Scriptable)args[i];
                length = NativeArray.getLengthProperty(cx, arg);
                long j = 0L;
                while (j < length) {
                    Object temp = NativeArray.getElem(cx, arg, j);
                    NativeArray.setElem(cx, result, slot, temp);
                    ++j;
                    ++slot;
                }
                continue;
            }
            NativeArray.setElem(cx, result, slot++, args[i]);
        }
        return result;
    }

    private Scriptable js_slice(Context cx, Scriptable thisObj, Object[] args) {
        long end;
        long begin;
        Scriptable scope = NativeArray.getTopLevelScope(this);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (args.length == 0) {
            begin = 0L;
            end = length;
        } else {
            begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
            end = args.length == 1 ? length : NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[1]), length);
        }
        for (long slot = begin; slot < end; ++slot) {
            Object temp = NativeArray.getElem(cx, thisObj, slot);
            NativeArray.setElem(cx, result, slot - begin, temp);
        }
        return result;
    }

    private static long toSliceIndex(double value, long length) {
        long result = value < 0.0 ? (value + (double)length < 0.0 ? 0L : (long)(value + (double)length)) : (value > (double)length ? length : (long)value);
        return result;
    }

    private Object indexOfHelper(Context cx, Scriptable thisObj, Object[] args, boolean isLast) {
        long start;
        Object compareTo = args.length > 0 ? args[0] : Undefined.instance;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        long l = args.length > 1 ? (long)ScriptRuntime.toInt32(ScriptRuntime.toNumber(args[1])) : (start = isLast ? length : 0L);
        if (start < 0L && (start += length) < 0L) {
            start = 0L;
        }
        if (isLast) {
            for (long i = start; i >= 0L; --i) {
                if (!ScriptRuntime.shallowEq(NativeArray.getElem(cx, thisObj, i), compareTo)) continue;
                return new Long(i);
            }
        } else {
            for (long i = start; i < length; ++i) {
                if (!ScriptRuntime.shallowEq(NativeArray.getElem(cx, thisObj, i), compareTo)) continue;
                return new Long(i);
            }
        }
        return NEGATIVE_ONE;
    }

    private Object iterativeMethod(Context cx, int id, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object callbackArg;
        Object object = callbackArg = args.length > 0 ? args[0] : Undefined.instance;
        if (callbackArg == null || !(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(callbackArg));
        }
        Function f = (Function)callbackArg;
        Scriptable parent = ScriptableObject.getTopLevelScope(f);
        Scriptable thisArg = args.length > 1 && args[1] instanceof Scriptable ? (Scriptable)args[1] : parent;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        Scriptable array = null;
        if (id == 18) {
            array = ScriptRuntime.newObject(cx, scope, "Array", null);
        } else if (id == 20) {
            Object[] ctorArgs = new Object[]{new Long(length)};
            array = ScriptRuntime.newObject(cx, scope, "Array", ctorArgs);
        }
        Object[] innerArgs = new Object[3];
        long j = 0L;
        block12: for (long i = 0L; i < length; ++i) {
            innerArgs[0] = NativeArray.getElem(cx, thisObj, i);
            innerArgs[1] = new Long(i);
            innerArgs[2] = thisObj;
            Object result = f.call(cx, parent, thisArg, innerArgs);
            switch (id) {
                case 17: {
                    if (ScriptRuntime.toBoolean(result)) continue block12;
                    return Boolean.FALSE;
                }
                case 18: {
                    if (!ScriptRuntime.toBoolean(result)) continue block12;
                    NativeArray.setElem(cx, array, j++, innerArgs[0]);
                    continue block12;
                }
                case 19: {
                    continue block12;
                }
                case 20: {
                    NativeArray.setElem(cx, array, j++, result);
                    continue block12;
                }
                case 21: {
                    if (!ScriptRuntime.toBoolean(result)) continue block12;
                    return Boolean.TRUE;
                }
            }
        }
        switch (id) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return array;
            }
            case 21: {
                return Boolean.FALSE;
            }
        }
        return Undefined.instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'm') {
                    if (s.charAt(2) != 'p' || s.charAt(1) != 'a') break;
                    return 20;
                }
                if (c != 'p' || s.charAt(2) != 'p' || s.charAt(1) != 'o') break;
                return 9;
            }
            case 4: {
                switch (s.charAt(2)) {
                    case 'i': {
                        X = "join";
                        id = 5;
                        break block0;
                    }
                    case 'm': {
                        X = "some";
                        id = 21;
                        break block0;
                    }
                    case 'r': {
                        X = "sort";
                        id = 7;
                        break block0;
                    }
                    case 's': {
                        X = "push";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(1);
                if (c == 'h') {
                    X = "shift";
                    id = 10;
                    break;
                }
                if (c == 'l') {
                    X = "slice";
                    id = 14;
                    break;
                }
                if (c != 'v') break;
                X = "every";
                id = 17;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "concat";
                    id = 13;
                    break;
                }
                if (c == 'f') {
                    X = "filter";
                    id = 18;
                    break;
                }
                if (c != 's') break;
                X = "splice";
                id = 12;
                break;
            }
            case 7: {
                switch (s.charAt(0)) {
                    case 'f': {
                        X = "forEach";
                        id = 19;
                        break block0;
                    }
                    case 'i': {
                        X = "indexOf";
                        id = 15;
                        break block0;
                    }
                    case 'r': {
                        X = "reverse";
                        id = 6;
                        break block0;
                    }
                    case 'u': {
                        X = "unshift";
                        id = 11;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 4;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c != 'l') break;
                X = "lastIndexOf";
                id = 16;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 3;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

