/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.org.mozilla.javascript;

import org.jasig.resource.org.mozilla.javascript.FunctionNode;
import org.jasig.resource.org.mozilla.javascript.Kit;
import org.jasig.resource.org.mozilla.javascript.Node;
import org.jasig.resource.org.mozilla.javascript.ObjArray;
import org.jasig.resource.org.mozilla.javascript.Parser;
import org.jasig.resource.org.mozilla.javascript.ScriptOrFnNode;
import org.jasig.resource.org.mozilla.javascript.ScriptRuntime;

final class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(132);
    }

    void initScript(ScriptOrFnNode scriptNode, Node body) {
        Node children = body.getFirstChild();
        if (children != null) {
            scriptNode.addChildrenToBack(children);
        }
    }

    Node createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    Node createLeaf(int nodeType, int nodeOp) {
        return new Node(nodeType, nodeOp);
    }

    Node createSwitch(Node expr, int lineno) {
        Node.Jump switchNode = new Node.Jump(110, expr, lineno);
        Node block = new Node(125, switchNode);
        return block;
    }

    void addSwitchCase(Node switchBlock, Node caseExpression, Node statements) {
        if (switchBlock.getType() != 125) {
            throw Kit.codeBug();
        }
        Node.Jump switchNode = (Node.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 110) {
            throw Kit.codeBug();
        }
        Node gotoTarget = Node.newTarget();
        if (caseExpression != null) {
            Node.Jump caseNode = new Node.Jump(111, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    void closeSwitch(Node switchBlock) {
        Node switchBreakTarget;
        if (switchBlock.getType() != 125) {
            throw Kit.codeBug();
        }
        Node.Jump switchNode = (Node.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 110) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = Node.newTarget();
        Node defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(this.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    Node createVariables(int token, int lineno) {
        return new Node(token, lineno);
    }

    Node createExprStatement(Node expr, int lineno) {
        int type = this.parser.insideFunction() ? 129 : 130;
        return new Node(type, expr, lineno);
    }

    Node createExprStatementNoReturn(Node expr, int lineno) {
        return new Node(129, expr, lineno);
    }

    Node createDefaultNamespace(Node expr, int lineno) {
        this.setRequiresActivation();
        Node n = this.createUnary(70, expr);
        Node result = this.createExprStatement(n, lineno);
        return result;
    }

    Node createName(String name) {
        this.checkActivationName(name, 38);
        return Node.newString(38, name);
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createNumber(double number) {
        return Node.newNumber(number);
    }

    Node createCatch(String varName, Node catchCond, Node stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(124);
        }
        return new Node(120, this.createName(varName), catchCond, stmts, lineno);
    }

    Node createThrow(Node expr, int lineno) {
        return new Node(49, expr, lineno);
    }

    Node createReturn(Node expr, int lineno) {
        return expr == null ? new Node(4, lineno) : new Node(4, expr, lineno);
    }

    Node createLabel(int lineno) {
        return new Node.Jump(126, lineno);
    }

    Node getLabelLoop(Node label) {
        return ((Node.Jump)label).getLoop();
    }

    Node createLabeledStatement(Node labelArg, Node statement) {
        Node.Jump label = (Node.Jump)labelArg;
        Node breakTarget = Node.newTarget();
        Node block = new Node(125, (Node)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    Node createBreak(Node breakStatement, int lineno) {
        Node.Jump jumpStatement;
        Node.Jump n = new Node.Jump(116, lineno);
        int t = breakStatement.getType();
        if (t == 128 || t == 126) {
            jumpStatement = (Node.Jump)breakStatement;
        } else if (t == 125 && breakStatement.getFirstChild().getType() == 110) {
            jumpStatement = (Node.Jump)breakStatement.getFirstChild();
        } else {
            throw Kit.codeBug();
        }
        n.setJumpStatement(jumpStatement);
        return n;
    }

    Node createContinue(Node loop, int lineno) {
        if (loop.getType() != 128) {
            Kit.codeBug();
        }
        Node.Jump n = new Node.Jump(117, lineno);
        n.setJumpStatement((Node.Jump)loop);
        return n;
    }

    Node createBlock(int lineno) {
        return new Node(125, lineno);
    }

    FunctionNode createFunction(String name) {
        return new FunctionNode(name);
    }

    Node initFunction(FunctionNode fnNode, int functionIndex, Node statements, int functionType) {
        Node lastStmt;
        String name;
        fnNode.itsFunctionType = functionType;
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.itsNeedsActivation = true;
            for (int i = 0; i != functionCount; ++i) {
                String name2;
                FunctionNode fn = fnNode.getFunctionNode(i);
                if (fn.getFunctionType() != 3 || (name2 = fn.getFunctionName()) == null || name2.length() == 0) continue;
                fnNode.removeParamOrVar(name2);
            }
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0 && !fnNode.hasParamOrVar(name)) {
            if (fnNode.addVar(name) == -2) {
                this.parser.addError("msg.const.redecl", name);
            }
            Node setFn = new Node(129, new Node(8, Node.newString(48, name), new Node(61)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new Node(4));
        }
        Node result = Node.newString(105, fnNode.getFunctionName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    void addChildToBack(Node parent, Node child) {
        parent.addChildToBack(child);
    }

    Node createLoopNode(Node loopLabel, int lineno) {
        Node.Jump result = new Node.Jump(128, lineno);
        if (loopLabel != null) {
            ((Node.Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    Node createWhile(Node loop, Node cond, Node body) {
        return this.createLoop((Node.Jump)loop, 1, body, cond, null, null);
    }

    Node createDoWhile(Node loop, Node body, Node cond) {
        return this.createLoop((Node.Jump)loop, 0, body, cond, null, null);
    }

    Node createFor(Node loop, Node init, Node test, Node incr, Node body) {
        return this.createLoop((Node.Jump)loop, 2, body, test, init, incr);
    }

    private Node createLoop(Node.Jump loop, int loopType, Node body, Node cond, Node init, Node incr) {
        Node bodyTarget = Node.newTarget();
        Node condTarget = Node.newTarget();
        if (loopType == 2 && cond.getType() == 124) {
            cond = new Node(44);
        }
        Node.Jump IFEQ = new Node.Jump(6, cond);
        IFEQ.target = bodyTarget;
        Node breakTarget = Node.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new Node(124, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(this.makeJump(5, condTarget));
            if (loopType == 2) {
                if (init.getType() != 124) {
                    if (init.getType() != 118) {
                        init = new Node(129, init);
                    }
                    loop.addChildToFront(init);
                }
                Node incrTarget = Node.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 124) {
                    incr = new Node(129, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    Node createForIn(Node loop, Node lhs, Node obj, Node body, boolean isForEach) {
        Node lvalue;
        int type = lhs.getType();
        if (type == 118) {
            Node lastChild = lhs.getLastChild();
            if (lhs.getFirstChild() != lastChild) {
                this.parser.reportError("msg.mult.index");
            }
            lvalue = Node.newString(38, lastChild.getString());
        } else {
            lvalue = this.makeReference(lhs);
            if (lvalue == null) {
                this.parser.reportError("msg.bad.for.in.lhs");
                return obj;
            }
        }
        Node localBlock = new Node(137);
        int initType = isForEach ? 58 : 57;
        Node init = new Node(initType, obj);
        init.putProp(3, localBlock);
        Node cond = new Node(59);
        cond.putProp(3, localBlock);
        Node id = new Node(60);
        id.putProp(3, localBlock);
        Node newBody = new Node(125);
        Node assign = this.simpleAssignment(lvalue, id);
        newBody.addChildToBack(new Node(129, assign));
        newBody.addChildToBack(body);
        loop = this.createWhile(loop, cond, newBody);
        loop.addChildToFront(init);
        if (type == 118) {
            loop.addChildToFront(lhs);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 125 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 125 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        Node handlerBlock = new Node(137);
        Node.Jump pn = new Node.Jump(77, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            Node catchTarget;
            Node endCatch = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, endCatch));
            pn.target = catchTarget = Node.newTarget();
            pn.addChildToBack(catchTarget);
            Node catchScopeBlock = new Node(137);
            Node cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                Node condStmt;
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node cond = name.getNext();
                Node catchStatement = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new Node(3));
                catchStatement.addChildToBack(this.makeJump(5, endCatch));
                if (cond.getType() == 124) {
                    condStmt = catchStatement;
                    hasDefault = true;
                } else {
                    condStmt = this.createIf(cond, catchStatement, null, catchLineNo);
                }
                Node catchScope = new Node(56, name, this.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(this.createUseLocal(catchScopeBlock), condStmt, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                Node rethrow = new Node(50);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            Node finallyTarget = Node.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(this.makeJump(131, finallyTarget));
            Node finallyEnd = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(121, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    Node createWith(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(125, lineno);
        result.addChildToBack(new Node(2, obj));
        Node bodyNode = new Node(119, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(3));
        return result;
    }

    public Node createDotQuery(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(142, obj, body, lineno);
        return result;
    }

    Node createArrayLiteral(ObjArray elems, int skipCount) {
        int length = elems.size();
        int[] skipIndexes = null;
        if (skipCount != 0) {
            skipIndexes = new int[skipCount];
        }
        Node array = new Node(63);
        int j = 0;
        for (int i = 0; i != length; ++i) {
            Node elem = (Node)elems.get(i);
            if (elem != null) {
                array.addChildToBack(elem);
                continue;
            }
            skipIndexes[j] = i;
            ++j;
        }
        if (skipCount != 0) {
            array.putProp(11, skipIndexes);
        }
        return array;
    }

    Node createObjectLiteral(ObjArray elems) {
        Object[] properties;
        int size = elems.size() / 2;
        Node object = new Node(64);
        if (size == 0) {
            properties = ScriptRuntime.emptyArgs;
        } else {
            properties = new Object[size];
            for (int i = 0; i != size; ++i) {
                properties[i] = elems.get(2 * i);
                Node value = (Node)elems.get(2 * i + 1);
                object.addChildToBack(value);
            }
        }
        object.putProp(12, properties);
        return object;
    }

    Node createRegExp(int regexpIndex) {
        Node n = new Node(47);
        n.putIntProp(4, regexpIndex);
        return n;
    }

    Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(125, lineno);
        }
        Node result = new Node(125, lineno);
        Node ifNotTarget = Node.newTarget();
        Node.Jump IFNE = new Node.Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            Node endTarget = Node.newTarget();
            result.addChildToBack(this.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    Node createCondExpr(Node cond, Node ifTrue, Node ifFalse) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(98, cond, ifTrue, ifFalse);
    }

    Node createUnary(int nodeType, Node child) {
        int childType = child.getType();
        switch (nodeType) {
            case 31: {
                Node n;
                if (childType == 38) {
                    child.setType(48);
                    Node left = child;
                    Node right = Node.newString(child.getString());
                    n = new Node(nodeType, left, right);
                } else if (childType == 33 || childType == 35) {
                    Node left = child.getFirstChild();
                    Node right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new Node(nodeType, left, right);
                } else if (childType == 65) {
                    Node ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new Node(67, ref);
                } else {
                    n = new Node(44);
                }
                return n;
            }
            case 32: {
                if (childType != 38) break;
                child.setType(133);
                return child;
            }
            case 27: {
                if (childType != 39) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 29: {
                if (childType != 39) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 26: {
                int status = IRFactory.isAlwaysDefinedBoolean(child);
                if (status == 0) break;
                int type = status == 1 ? 43 : 44;
                if (childType == 44 || childType == 43) {
                    child.setType(type);
                    return child;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, child);
    }

    Node createCallOrNew(int nodeType, Node child) {
        String name;
        int type = 0;
        if (child.getType() == 38) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    Node createIncDec(int nodeType, boolean post, Node child) {
        if ((child = this.makeReference(child)) == null) {
            String msg = nodeType == 103 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(msg);
            return null;
        }
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 35: 
            case 38: 
            case 65: {
                Node n = new Node(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 103) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node target, String namespace, String name, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.createName(name);
            }
            this.checkActivationName(name, 33);
            if (ScriptRuntime.isSpecialProperty(name)) {
                Node ref = new Node(69, target);
                ref.putProp(17, name);
                return new Node(65, ref);
            }
            return new Node(33, target, this.createString(name));
        }
        Node elem = this.createString(name);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1);
    }

    Node createElementGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                throw Kit.codeBug();
            }
            return new Node(35, target, elem);
        }
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags);
    }

    private Node createMemberRefGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        Node nsNode = null;
        if (namespace != null) {
            nsNode = namespace.equals("*") ? new Node(41) : this.createName(namespace);
        }
        Node ref = target == null ? (namespace == null ? new Node(75, elem) : new Node(76, nsNode, elem)) : (namespace == null ? new Node(73, target, elem) : new Node(74, target, nsNode, elem));
        if (memberTypeFlags != 0) {
            ref.putIntProp(16, memberTypeFlags);
        }
        return new Node(65, ref);
    }

    Node createBinary(int nodeType, Node left, Node right) {
        switch (nodeType) {
            case 21: {
                if (left.type == 40) {
                    String s2;
                    if (right.type == 40) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 39) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 39) break;
                if (right.type == 39) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 40) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 39) {
                    double ld = left.getDouble();
                    if (right.type == 39) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(29, right);
                }
                if (right.type != 39 || right.getDouble() != 0.0) break;
                return new Node(28, left);
            }
            case 23: {
                if (left.type == 39) {
                    double ld = left.getDouble();
                    if (right.type == 39) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(28, right);
                }
                if (right.type != 39 || right.getDouble() != 1.0) break;
                return new Node(28, left);
            }
            case 24: {
                if (right.type != 39) break;
                double rd = right.getDouble();
                if (left.type == 39) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(28, left);
            }
            case 101: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 100: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new Node(nodeType, left, right);
    }

    private Node simpleAssignment(Node left, Node right) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 38: {
                left.setType(48);
                return new Node(8, left, right);
            }
            case 33: 
            case 35: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 34 : 36;
                return new Node(type, obj, id, right);
            }
            case 65: {
                Node ref = left.getFirstChild();
                this.checkMutableReference(ref);
                return new Node(66, ref, right);
            }
        }
        throw Kit.codeBug();
    }

    private void checkMutableReference(Node n) {
        int memberTypeFlags = n.getIntProp(16, 0);
        if ((memberTypeFlags & 4) != 0) {
            this.parser.reportError("msg.bad.assign.left");
        }
    }

    Node createAssignment(int assignType, Node left, Node right) {
        int assignOp;
        if ((left = this.makeReference(left)) == null) {
            this.parser.reportError("msg.bad.assign.left");
            return right;
        }
        switch (assignType) {
            case 86: {
                return this.simpleAssignment(left, right);
            }
            case 87: {
                assignOp = 9;
                break;
            }
            case 88: {
                assignOp = 10;
                break;
            }
            case 89: {
                assignOp = 11;
                break;
            }
            case 90: {
                assignOp = 18;
                break;
            }
            case 91: {
                assignOp = 19;
                break;
            }
            case 92: {
                assignOp = 20;
                break;
            }
            case 93: {
                assignOp = 21;
                break;
            }
            case 94: {
                assignOp = 22;
                break;
            }
            case 95: {
                assignOp = 23;
                break;
            }
            case 96: {
                assignOp = 24;
                break;
            }
            case 97: {
                assignOp = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 38: {
                String s = left.getString();
                Node opLeft = Node.newString(38, s);
                Node op = new Node(assignOp, opLeft, right);
                Node lvalueLeft = Node.newString(48, s);
                return new Node(8, lvalueLeft, op);
            }
            case 33: 
            case 35: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 135 : 136;
                Node opLeft = new Node(134);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
            case 65: {
                Node ref = left.getFirstChild();
                this.checkMutableReference(ref);
                Node opLeft = new Node(134);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(138, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    Node createUseLocal(Node localBlock) {
        if (137 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        Node result = new Node(53);
        result.putProp(3, localBlock);
        return result;
    }

    private Node.Jump makeJump(int type, Node target) {
        Node.Jump n = new Node.Jump(type);
        n.target = target;
        return n;
    }

    private Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 35: 
            case 38: 
            case 65: {
                return node;
            }
            case 37: {
                node.setType(68);
                return new Node(65, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 41: 
            case 43: {
                return -1;
            }
            case 44: {
                return 1;
            }
            case 39: {
                double num = node.getDouble();
                if (num == num && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void checkActivationName(String name, int token) {
        if (this.parser.insideFunction()) {
            boolean activation = false;
            if ("arguments".equals(name) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.containsKey(name)) {
                activation = true;
            } else if ("length".equals(name) && token == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                activation = true;
            }
            if (activation) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }
}

