/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.aggr;

import javax.servlet.ServletContext;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesElementsProviderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesElementsProviderUtils.class);

    private ResourcesElementsProviderUtils() {
    }

    public static ResourcesElementsProvider getResourcesElementsProvider(ServletContext servletContext) {
        return (ResourcesElementsProvider)servletContext.getAttribute(ResourcesElementsProvider.RESOURCES_ELEMENTS_PROVIDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourcesElementsProvider getOrCreateResourcesElementsProvider(ServletContext servletContext) {
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            ResourcesElementsProvider resourcesElementsProvider = ResourcesElementsProviderUtils.getResourcesElementsProvider(servletContext);
            if (resourcesElementsProvider != null) {
                return resourcesElementsProvider;
            }
            LOGGER.warn("No ResourcesElementsProvider found as a ServletContext attribute. Creating a new ResourcesElementsProviderImpl and caching it in the ServletContext under key: {}", (Object)ResourcesElementsProvider.RESOURCES_ELEMENTS_PROVIDER);
            ResourcesElementsProviderImpl provider = new ResourcesElementsProviderImpl();
            provider.setServletContext(servletContext);
            try {
                provider.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create ResourcesElementsProviderImpl on demand", e);
            }
            servletContext.setAttribute(ResourcesElementsProvider.RESOURCES_ELEMENTS_PROVIDER, (Object)provider);
            return provider;
        }
    }
}

