/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.aggr;

import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.resourceserver.aggr.ResourcesDao;
import org.jasig.resourceserver.aggr.ResourcesDaoImpl;
import org.jasig.resourceserver.aggr.om.BasicInclude;
import org.jasig.resourceserver.aggr.om.Css;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.aggr.om.Js;
import org.jasig.resourceserver.aggr.om.Parameter;
import org.jasig.resourceserver.aggr.om.Resources;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ClassRelativeResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResourceLoader;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourcesElementsProviderImpl
implements ResourceLoaderAware,
ServletContextAware,
InitializingBean,
ResourcesElementsProvider {
    private static final String OPEN_COND_COMMENT_PRE = "[";
    private static final String OPEN_COND_COMMENT_POST = "]> ";
    private static final String CLOSE_COND_COMMENT = " <![endif]";
    private static final String OPEN_SCRIPT = "<script type=\"text/javascript\" src=\"";
    private static final String CLOSE_SCRIPT = "\"></script>";
    private static final String OPEN_STYLE = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
    private static final String CLOSE_STYLE = "\"/>";
    private static final String SCRIPT = "script";
    private static final String LINK = "link";
    private static final String REL = "rel";
    private static final String SRC = "src";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String MEDIA = "media";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentBuilder documentBuilder;
    private final TransformerFactory transformerFactory;
    private ResourceLoader resourceLoader;
    private ServletContext servletContext;
    private ResourcesDao resourcesDao;
    private boolean registerWithServletContext = true;
    private Map<String, String> resolvedResourceCache = CacheBuilder.newBuilder().maximumSize(500L).build().asMap();
    private Map<String, String> htmlResourcesCache = CacheBuilder.newBuilder().maximumSize(100L).build().asMap();
    private Map<String, DocumentFragment> xmlResourcesCache = CacheBuilder.newBuilder().maximumSize(100L).build().asMap();

    public ResourcesElementsProviderImpl() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create DocumentBuilder", e);
        }
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setResourcesDao(ResourcesDao resourcesDao) {
        this.resourcesDao = resourcesDao;
    }

    public void setRegisterWithServletContext(boolean registerWithServletContext) {
        this.registerWithServletContext = registerWithServletContext;
    }

    public void setResolvedResourceCache(Map<String, String> resolvedResourceCache) {
        this.resolvedResourceCache = resolvedResourceCache;
    }

    public void setHtmlResourcesCache(Map<String, String> htmlResourcesCache) {
        this.htmlResourcesCache = htmlResourcesCache;
    }

    public void setXmlResourcesCache(Map<String, DocumentFragment> xmlResourcesCache) {
        this.xmlResourcesCache = xmlResourcesCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.registerWithServletContext && this.servletContext != null) {
            this.servletContext.setAttribute(RESOURCES_ELEMENTS_PROVIDER, (Object)this);
        }
        if (this.resourcesDao == null) {
            this.resourcesDao = new ResourcesDaoImpl();
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = this.servletContext != null ? new ServletContextResourceLoader(this.servletContext) : new ClassRelativeResourceLoader(this.getClass());
        }
    }

    @Override
    public String resolveResourceUrl(HttpServletRequest request, String resource) {
        String resourceUrl;
        Included includedType = this.getIncludedType(request);
        if (Included.AGGREGATED == includedType && (resourceUrl = this.resolvedResourceCache.get(resource)) != null) {
            return resourceUrl;
        }
        String resourceContextPath = this.resolveResourceContextPath(request, resource);
        resourceUrl = resourceContextPath.concat(resource);
        this.logger.debug("Resolved {} to {}", (Object)resource, (Object)resourceUrl);
        if (Included.AGGREGATED == includedType) {
            this.resolvedResourceCache.put(resource, resourceUrl);
        }
        return resourceUrl;
    }

    @Override
    public void setDefaultIncludedType(Included included) {
        switch (included) {
            case AGGREGATED: {
                System.setProperty(AGGREGATED_THEME_PARAMETER, Boolean.TRUE.toString());
                break;
            }
            case PLAIN: {
                System.setProperty(AGGREGATED_THEME_PARAMETER, Boolean.FALSE.toString());
                this.resolvedResourceCache.clear();
                this.htmlResourcesCache.clear();
                this.xmlResourcesCache.clear();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Included type: " + included);
            }
        }
    }

    @Override
    public Included getDefaultIncludedType() {
        String aggregationParameter = System.getProperty(AGGREGATED_THEME_PARAMETER);
        if (aggregationParameter == null) {
            aggregationParameter = System.getProperty("org.jasig.resource.aggr.util.aggregated_theme");
        }
        if (aggregationParameter == null) {
            aggregationParameter = System.getProperty("org.jasig.portal.web.skin.aggregated_theme");
        }
        if (aggregationParameter == null) {
            aggregationParameter = DEFAULT_AGGREGATION_ENABLED;
        }
        if (Boolean.parseBoolean(aggregationParameter)) {
            return Included.AGGREGATED;
        }
        return Included.PLAIN;
    }

    @Override
    public Included getIncludedType(HttpServletRequest request) {
        return this.getDefaultIncludedType();
    }

    @Override
    public String getResourcesParameter(HttpServletRequest request, String skinXml, String name) {
        Resources skinResources = this.getResources(request, skinXml);
        if (skinResources == null) {
            this.logger.warn("Could not find skin file " + skinXml);
            return null;
        }
        for (Parameter parameter : skinResources.getParameter()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public NodeList getResourcesXmlFragment(HttpServletRequest request, String skinXml) {
        DocumentFragment headFragment = this.getResourcesXml(request, skinXml);
        return headFragment.getChildNodes();
    }

    @Override
    public String getResourcesHtmlFragment(HttpServletRequest request, String skinXml) {
        String htmlFragment;
        Included includedType = this.getIncludedType(request);
        if (Included.AGGREGATED == includedType && (htmlFragment = this.htmlResourcesCache.get(skinXml)) != null) {
            return htmlFragment;
        }
        DocumentFragment resourcesXml = this.getResourcesXml(request, skinXml);
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            if (Included.PLAIN == this.getIncludedType(request)) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(resourcesXml), new StreamResult(stringWriter));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize XML fragment to HTML fragment", e);
        }
        htmlFragment = stringWriter.toString();
        if (Included.AGGREGATED == includedType) {
            this.htmlResourcesCache.put(skinXml, htmlFragment);
        }
        return htmlFragment;
    }

    @Override
    public Resources getResources(HttpServletRequest request, String skinXml) {
        File skinFile;
        Included includedType = this.getIncludedType(request);
        Resource skinResource = this.getResource(skinXml);
        try {
            skinFile = skinResource.getFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get File for skin XML path: " + skinXml, e);
        }
        switch (includedType) {
            case AGGREGATED: {
                String aggregatedSkinXml = this.resourcesDao.getAggregatedSkinName(skinFile.getName());
                File aggregatedSkinFile = new File(skinFile.getParentFile(), aggregatedSkinXml);
                if (aggregatedSkinFile.exists()) {
                    return this.resourcesDao.readResources(aggregatedSkinFile, includedType);
                }
                this.logger.warn("Could not find aggregated skin XML '" + aggregatedSkinFile + "' for '" + skinFile + "', falling back on unaggregated version.");
            }
            case PLAIN: {
                return this.resourcesDao.readResources(skinFile, includedType);
            }
        }
        throw new UnsupportedOperationException("Unknown Included type: " + includedType);
    }

    protected String resolveResourceContextPath(HttpServletRequest request, String resource) {
        String resourceContextPath = this.getResourceServerContextPath();
        this.logger.debug("Attempting to locate resource serving webapp with context path: {}", (Object)resourceContextPath);
        ServletContext resourceContext = this.servletContext.getContext(resourceContextPath);
        if (resourceContext == null || !resourceContextPath.equals(resourceContext.getContextPath())) {
            this.logger.warn("Could not find resource serving webapp under context path {} ensure the resource server is deployed and cross context dispatching is enable for this web application", (Object)resourceContextPath);
            return request.getContextPath();
        }
        this.logger.debug("Found resource serving webapp at: {}", (Object)resourceContextPath);
        URL url = null;
        try {
            url = resourceContext.getResource(resource);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            this.logger.debug("Resource serving webapp {} doesn't contain resource {} Falling back to the local resource.", (Object)resourceContextPath, (Object)resource);
            return request.getContextPath();
        }
        this.logger.debug("Resource serving webapp {} contains resource {} Using resource server.", (Object)resourceContextPath, (Object)resource);
        return resourceContextPath;
    }

    protected String getResourceServerContextPath() {
        String resourceContextPath = this.servletContext.getInitParameter("resourceContextPath");
        if (resourceContextPath == null) {
            return "/ResourceServingWebapp";
        }
        if (!resourceContextPath.startsWith("/")) {
            return "/".concat(resourceContextPath);
        }
        return resourceContextPath;
    }

    protected DocumentFragment getResourcesXml(HttpServletRequest request, String skinXml) {
        DocumentFragment headFragment;
        Included includedType = this.getIncludedType(request);
        if (Included.AGGREGATED == includedType && (headFragment = this.xmlResourcesCache.get(skinXml)) != null) {
            return headFragment;
        }
        Resources skinResources = this.getResources(request, skinXml);
        if (skinResources == null) {
            this.logger.warn("Could not find skin file " + skinXml);
            return null;
        }
        Document doc = this.documentBuilder.newDocument();
        headFragment = doc.createDocumentFragment();
        String relativeRoot = request.getContextPath() + "/" + FilenameUtils.getPath((String)skinXml);
        for (Css css : skinResources.getCss()) {
            this.appendCssNode(request, doc, headFragment, css, relativeRoot);
        }
        for (Js js : skinResources.getJs()) {
            this.appendJsNode(request, doc, headFragment, js, relativeRoot);
        }
        if (Included.AGGREGATED == includedType) {
            this.xmlResourcesCache.put(skinXml, headFragment);
        }
        return headFragment;
    }

    protected Resource getResource(String skinXml) {
        if (!skinXml.startsWith("/")) {
            skinXml = "/" + skinXml;
        }
        return this.resourceLoader.getResource(skinXml);
    }

    protected void appendJsNode(HttpServletRequest request, Document document, DocumentFragment head, Js js, String relativeRoot) {
        String scriptPath = this.getElementPath(request, js, relativeRoot);
        if (this.resourcesDao.isConditional((BasicInclude)js)) {
            Comment c = document.createComment("");
            c.appendData(OPEN_COND_COMMENT_PRE);
            c.appendData(js.getConditional());
            c.appendData(OPEN_COND_COMMENT_POST);
            c.appendData(OPEN_SCRIPT);
            c.appendData(scriptPath);
            c.appendData(CLOSE_SCRIPT);
            c.appendData(CLOSE_COND_COMMENT);
            head.appendChild(c);
        } else {
            Element element = document.createElement(SCRIPT);
            element.setAttribute(TYPE, "text/javascript");
            element.setAttribute(SRC, scriptPath);
            element.appendChild(document.createTextNode(" "));
            head.appendChild(element);
        }
    }

    protected void appendCssNode(HttpServletRequest request, Document document, DocumentFragment head, Css css, String relativeRoot) {
        String stylePath = this.getElementPath(request, css, relativeRoot);
        if (this.resourcesDao.isConditional((BasicInclude)css)) {
            Comment c = document.createComment("");
            c.appendData(OPEN_COND_COMMENT_PRE);
            c.appendData(css.getConditional());
            c.appendData(OPEN_COND_COMMENT_POST);
            c.appendData(OPEN_STYLE);
            c.appendData(stylePath);
            if (StringUtils.isNotBlank((String)css.getMedia())) {
                c.appendData("\" media=\"");
                c.appendData(css.getMedia());
            }
            c.appendData(CLOSE_STYLE);
            c.appendData(CLOSE_COND_COMMENT);
            head.appendChild(c);
        } else {
            Element element = document.createElement(LINK);
            element.setAttribute(REL, "stylesheet");
            element.setAttribute(TYPE, "text/css");
            element.setAttribute(HREF, stylePath);
            if (StringUtils.isNotBlank((String)css.getMedia())) {
                element.setAttribute(MEDIA, css.getMedia());
            }
            head.appendChild(element);
        }
    }

    protected <T extends BasicInclude> String getElementPath(HttpServletRequest request, T basicInclude, String relativeRoot) {
        String path = basicInclude.getValue();
        if (!this.resourcesDao.isAbsolute(basicInclude)) {
            path = FilenameUtils.normalize((String)(relativeRoot + path));
            path = FilenameUtils.separatorsToUnix((String)path);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("translated relative path {} to {}", (Object)basicInclude.getValue(), (Object)path);
            }
        } else if (basicInclude.isResource()) {
            path = this.resolveResourceUrl(request, path);
        }
        return path;
    }
}

