/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarDataDao;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultAvailableScheduleReflectionServiceImpl
implements AvailableScheduleReflectionService {
    protected static final Log LOG = LogFactory.getLog(DefaultAvailableScheduleReflectionServiceImpl.class);
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private ICalendarDataDao calendarDataDao;
    private AvailableScheduleDao availableScheduleDao;
    private OwnerDao ownerDao;
    private TransactionTemplate transactionTemplate;
    private boolean supportsForUpdate = false;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired
    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionTemplate = new TransactionTemplate(platformTransactionManager);
        this.transactionTemplate.setIsolationLevel(Isolation.READ_COMMITTED.value());
    }

    @Autowired
    public void setCalendarDataDao(ICalendarDataDao calendarDataDao) {
        this.calendarDataDao = calendarDataDao;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    public void setSupportsForUpdate(boolean supportsForUpdate) {
        this.supportsForUpdate = supportsForUpdate;
    }

    @Override
    public void reflectAvailableSchedule(IScheduleOwner owner) {
        boolean success = this.processScheduleOwner(owner);
        if (!success) {
            LOG.warn((Object)("failed to process owner " + owner));
        }
    }

    protected boolean processScheduleOwner(final IScheduleOwner owner) {
        this.addOwnerToLockTableIfNotPresent(owner);
        boolean result = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                if (DefaultAvailableScheduleReflectionServiceImpl.this.lock(owner)) {
                    AvailableSchedule schedule = DefaultAvailableScheduleReflectionServiceImpl.this.availableScheduleDao.retrieve(owner);
                    DefaultAvailableScheduleReflectionServiceImpl.this.calendarDataDao.reflectAvailableSchedule(owner, schedule);
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    @Override
    public void reflectAvailableSchedule(long ownerId) {
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(ownerId);
        this.reflectAvailableSchedule(owner);
    }

    @Override
    public void purgeReflections(IScheduleOwner owner, Date start, Date end) {
        this.calendarDataDao.purgeAvailableScheduleReflections(owner, start, end);
    }

    @Override
    public void purgeReflections(long ownerId, Date start, Date end) {
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(ownerId);
        this.purgeReflections(owner, start, end);
    }

    void addOwnerToLockTableIfNotPresent(IScheduleOwner owner) {
        List locks = this.simpleJdbcTemplate.query("select owner_id from reflect_locks where owner_id = ?", (RowMapper)new SingleColumnRowMapper(Long.class), new Object[]{owner.getId()});
        Long lock = (Long)DataAccessUtils.singleResult((Collection)locks);
        if (lock == null) {
            int rows = this.simpleJdbcTemplate.update("insert into reflect_locks (owner_id) values (?)", new Object[]{owner.getId()});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("inserted " + rows + " row into reflect_locks for owner id " + owner.getId()));
            }
        }
    }

    boolean lock(IScheduleOwner owner) {
        StringBuilder sql = new StringBuilder();
        sql.append("select owner_id from reflect_locks where owner_id = ?");
        if (this.supportsForUpdate) {
            sql.append(" for update nowait");
        }
        try {
            this.simpleJdbcTemplate.query(sql.toString(), (RowMapper)new SingleColumnRowMapper(), new Object[]{owner.getId()});
            LOG.debug((Object)("lock acquired for owner " + owner));
            return true;
        }
        catch (CannotAcquireLockException e) {
            LOG.warn((Object)("lock attempt failed for owner " + owner));
            return false;
        }
    }
}

